/*
 * Decompiled with CFR 0.152.
 */
package trier.sequencediagram.figure;

import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import trier.TrierPlugin;
import trier.sequencediagram.QDConstants;
import trier.sequencediagram.figure.QDElementFigure;
import trier.sequencediagram.figure.QDSequenciableElementFigure;

public class QDSequenciableObjectFigure
extends QDSequenciableElementFigure {
    protected QDElementFigure createObjectFigure() {
        return new QDObjectFigure();
    }

    class QDObjectFigure
    extends QDElementFigure {
        private Figure titleLayer = new Figure();
        private Label titleLabel = new Label();
        public static final int xMargin = 10;
        public static final int yMargin = 20;
        private int layoutCurrentHeight = 0;

        public QDObjectFigure() {
            this.initialize();
            this.initializeComponents();
        }

        protected void initialize() {
            this.setLayoutManager((LayoutManager)new XYLayout());
            this.setBorder(null);
        }

        protected void initializeComponents() {
            DelegatingLayout titleLayout = new DelegatingLayout();
            this.titleLayer.setLayoutManager((LayoutManager)titleLayout);
            this.titleLayer.setForegroundColor(QDConstants.DEFAULT_SEQUENCE_PEN_COLOR);
            this.add((IFigure)this.titleLayer);
            this.titleLayer.add((IFigure)this.titleLabel, (Object)new TitleLabelLocator());
        }

        public Label getTitleLabel() {
            return this.titleLabel;
        }

        public void setBounds(Rectangle r) {
            super.setBounds(r);
            this.titleLayer.setBounds(r);
        }

        public void add(IFigure figure, Object constraint, int index) {
            if (index == -1) {
                super.add(figure, constraint, index);
            } else if (figure == this.titleLayer) {
                super.add(figure, constraint, 0);
            } else {
                super.add(figure, constraint, index + 1);
            }
        }

        protected void paintFigure(Graphics g) {
            super.paintFigure(g);
            g.setForegroundColor(TrierPlugin.DEFAULT_CLASS_PEN_COLOR);
            g.setBackgroundColor(TrierPlugin.DEFAULT_CLASS_FILL_COLOR);
            g.setLineWidth(1);
            Rectangle r = super.getBounds();
            r = this.getBoundsForDraw(1);
            this.drawObject(g, r);
        }

        private void drawObject(Graphics g, Rectangle r) {
            g.fillRectangle(r);
            g.drawRectangle(r.x, r.y, r.width, r.height - 60);
            Rectangle labelBounds = QDSequenciableObjectFigure.this.getTitleLabel().getBounds();
            g.drawLine(labelBounds.getBottomLeft(), labelBounds.getBottomRight());
            Polyline line = new Polyline();
            line.setLineStyle(3);
            line.setLocation(new Point(r.getTop().x, r.getTop().y + 60));
            line.setStart(new Point(r.getTop().x, r.getTop().y + 60));
            line.setEnd(r.getBottom());
            line.paint(g);
        }

        private int layoutGetWidth() {
            Rectangle r = this.getBounds();
            return r.width;
        }

        private int layoutGetHeight() {
            Rectangle r = this.getBounds();
            return r.height;
        }

        private Point layoutGetLocation() {
            Rectangle r = this.getBounds();
            int x = r.x + 10;
            int y = r.y + this.layoutCurrentHeight;
            return new Point(x, y);
        }

        private Point layoutGetLocationNoMargin() {
            Rectangle r = this.getBounds();
            int x = r.x;
            int y = r.y + this.layoutCurrentHeight;
            return new Point(x, y);
        }

        class TitleLabelLocator
        implements Locator {
            TitleLabelLocator() {
            }

            public void relocate(IFigure target) {
                QDObjectFigure.this.layoutCurrentHeight = 20;
                int width = QDObjectFigure.this.layoutGetWidth() - 20;
                int height = target.getPreferredSize().height;
                target.setBounds(new Rectangle(QDObjectFigure.this.layoutGetLocation(), new Dimension(width, height)));
                QDObjectFigure qDObjectFigure = QDObjectFigure.this;
                qDObjectFigure.layoutCurrentHeight = qDObjectFigure.layoutCurrentHeight + height;
            }
        }
    }
}

