/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.io.xml;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectConstants;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectIDMapper;
import jp.ac.keio.sfc.crew.io.xml.XMLSerializable;
import jp.ac.keio.sfc.crew.refrection.ArrayObject;
import jp.ac.keio.sfc.crew.refrection.ClassObject;
import jp.ac.keio.sfc.crew.refrection.FieldObject;
import jp.ac.keio.sfc.crew.refrection.ObjectObject;
import jp.ac.keio.sfc.crew.refrection.PrimitiveObject;
import jp.ac.keio.sfc.crew.refrection.primitives.BooleanObject;
import jp.ac.keio.sfc.crew.refrection.primitives.ByteObject;
import jp.ac.keio.sfc.crew.refrection.primitives.CharObject;
import jp.ac.keio.sfc.crew.refrection.primitives.DoubleObject;
import jp.ac.keio.sfc.crew.refrection.primitives.FloatObject;
import jp.ac.keio.sfc.crew.refrection.primitives.IntObject;
import jp.ac.keio.sfc.crew.refrection.primitives.LongObject;
import jp.ac.keio.sfc.crew.refrection.primitives.ShortObject;
import jp.ac.keio.sfc.crew.refrection.primitives.StringObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLObjectOutputStream
extends ObjectOutputStream
implements XMLObjectConstants {
    private Document doc;
    private XMLObjectIDMapper idMap = new XMLObjectIDMapper();
    private Map writtenObjects = new IdentityHashMap();
    private Stack elementStack = new Stack();
    private Stack objectStack = new Stack();
    private boolean referenceMode = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public XMLObjectOutputStream(Document doc) throws IOException {
        this.doc = doc;
    }

    private void pushElement(Element element) {
        this.elementStack.push(element);
    }

    private Element popElement() {
        return (Element)this.elementStack.pop();
    }

    private Element getCurrentElement() {
        if (this.elementStack.isEmpty()) {
            return null;
        }
        return (Element)this.elementStack.peek();
    }

    private void pushObject(Object object) {
        this.objectStack.push(object);
    }

    private Object popObject() {
        return this.objectStack.pop();
    }

    private Object getCurrentObject() {
        return this.objectStack.peek();
    }

    private boolean isWrittenObject(Object obj) {
        return this.writtenObjects.containsKey(obj);
    }

    private void addWrittenObject(Object obj) {
        this.writtenObjects.put(obj, null);
    }

    public void startNewElement(String tagName) {
        try {
            Element element = this.doc.createElement(tagName);
            Element current = this.getCurrentElement();
            if (current == null) {
                this.doc.appendChild(element);
            } else {
                current.appendChild(element);
            }
            this.pushElement(element);
        }
        catch (DOMException domEx) {
            throw new RuntimeException("start tag failed ::tagname=" + tagName, domEx);
        }
    }

    public void finishCurrentElement() {
        this.popElement();
    }

    public void setAttribute(String name, String value) {
        if (name.equals("_name") && value.startsWith("$")) {
            value = value.substring(1);
        }
        if (value.indexOf(XMLObjectConstants.CR) != -1) {
            value = value.replaceAll(XMLObjectConstants.CR, "&cr;");
        }
        this.getCurrentElement().setAttribute(name, value);
    }

    public boolean isReferenceMode() {
        return this.referenceMode;
    }

    public void setReferenceMode(boolean referenceMode) {
        this.referenceMode = referenceMode;
    }

    private String getID(Object object) {
        return this.idMap.putObject(object);
    }

    private String createTagName(Object object) {
        String tagName = null;
        tagName = object instanceof XMLSerializable ? ((XMLSerializable)object).getTagName() : (object instanceof Collection ? "Collection" : (object instanceof Map ? "Map" : "Object"));
        return tagName;
    }

    private boolean isPrimitive(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.equals(clazz2);
    }

    private ObjectObject createObjectObject(Object obj) {
        return new ObjectObject(obj, 152);
    }

    protected void writeObjectOverride(Object obj) throws IOException {
        this.writeObjectWithName(null, obj);
    }

    public void writeObjectWithName(String name, Object obj) throws IOException {
        if (obj == null) {
            this.writeNullObjectWithName(name);
        } else if (this.isPrimitive(obj.getClass())) {
            this.writePrimitiveWithName(name, PrimitiveObject.createObject(obj.getClass(), obj));
        } else if (obj.getClass().isArray()) {
            this.writeArrayWithName(name, ArrayObject.createObject(obj));
        } else if (this.isWrittenObject(obj) || this.referenceMode) {
            this.writeObjectAsReferenceWithName(name, obj);
        } else {
            this.writeObjectImpl(name, obj);
        }
    }

    private void writeObjectImpl(String name, Object obj) throws IOException {
        this.startNewElement(this.createTagName(obj));
        if (name != null) {
            this.setAttribute("_name", name);
        }
        this.setAttribute("_id", this.getID(obj));
        this.setAttribute("_class", obj.getClass().getName());
        this.writeObjectImplImpl(obj);
        this.finishCurrentElement();
    }

    private void writeObjectImplImpl(Object obj) throws IOException {
        this.pushObject(obj);
        if (!this.referenceMode) {
            this.addWrittenObject(obj);
        }
        if (obj instanceof XMLSerializable) {
            ((XMLSerializable)obj).writeObject(this);
        } else if (obj instanceof Collection) {
            this.writeAsCollection((Collection)obj);
        } else if (obj instanceof Map) {
            this.writeAsMap((Map)obj);
        } else {
            ObjectObject wrapper = new ObjectObject(obj);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.io.ObjectOutputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (wrapper.hasMethod("writeObject", clazz)) {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.io.ObjectOutputStream");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                wrapper.invokeMethod("writeObject", clazz2, this);
            } else {
                this.defaultWriteObject();
            }
        }
        this.popObject();
    }

    public void defaultWriteObject() throws IOException {
        Object currentObject = this.getCurrentObject();
        ObjectObject wrapper = this.createObjectObject(currentObject);
        Iterator i = wrapper.getAllFields().iterator();
        while (i.hasNext()) {
            FieldObject field = (FieldObject)i.next();
            String name = field.getName();
            Object value = field.getValue();
            if (ClassObject.lookup(field.getType()).isPrimitive()) {
                this.writePrimitiveAsAttribute(name, PrimitiveObject.createObject(field.getValue()));
                continue;
            }
            if (!name.startsWith("$")) {
                this.writeObjectWithName(name, value);
                continue;
            }
            this.writeObjectAsReferenceWithName(name, value);
        }
    }

    public void writeNullObject() {
        this.writeNullObjectWithName(null);
    }

    public void writeNullObjectWithName(String name) {
        this.writeNullObjectImpl(name);
    }

    private void writeNullObjectImpl(String name) {
        this.startNewElement("NullObject");
        if (name != null) {
            this.setAttribute("_name", name);
        }
        this.finishCurrentElement();
    }

    public void writeObjectAsReference(Object obj) throws IOException {
        this.writeObjectAsReferenceWithName(null, obj);
    }

    public void writeObjectAsReferenceWithName(String name, Object obj) throws IOException {
        if (obj == null) {
            this.writeNullObjectWithName(name);
        } else if (this.isPrimitive(obj.getClass())) {
            this.writePrimitiveWithName(name, PrimitiveObject.createObject(obj.getClass(), obj));
        } else if (obj.getClass().isArray()) {
            this.writeArrayAsReferenceWithName(name, ArrayObject.createObject(obj));
        } else if (obj instanceof Collection || obj instanceof Map) {
            boolean ref = this.isReferenceMode();
            this.setReferenceMode(true);
            this.writeObjectImpl(name, obj);
            this.setReferenceMode(ref);
        } else {
            this.writeObjectAsReferenceImpl(name, obj);
        }
    }

    private void writeObjectAsReferenceImpl(String name, Object obj) {
        this.startNewElement("ObjectReference");
        if (name != null) {
            this.setAttribute("_name", name);
        }
        this.setAttribute("idref", this.getID(obj));
        this.finishCurrentElement();
    }

    public void writePrimitiveAsAttribute(String name, PrimitiveObject primitiveObject) {
        this.setAttribute(name, primitiveObject.getValueAsString());
    }

    public void writePrimitive(PrimitiveObject primitiveObject) {
        this.writePrimitiveWithName(null, primitiveObject);
    }

    public void writePrimitiveWithName(String name, PrimitiveObject primitiveObject) {
        this.writePrimitiveImpl(name, primitiveObject);
    }

    private void writePrimitiveImpl(String name, PrimitiveObject primitiveObject) {
        this.startNewElement("Primitive");
        if (name != null) {
            this.setAttribute("_name", name);
        }
        this.setAttribute("_class", primitiveObject.getType().getName());
        this.setAttribute("value", primitiveObject.getValueAsString());
        this.finishCurrentElement();
    }

    public void writeArray(ArrayObject arrayObject) {
        this.writeArrayWithName(null, arrayObject);
    }

    public void writeArrayWithName(String name, ArrayObject arrayObject) {
        this.writeArrayImpl(name, arrayObject, false);
    }

    public void writeArrayAsReference(ArrayObject arrayObject) {
        this.writeArrayAsReferenceWithName(null, arrayObject);
    }

    public void writeArrayAsReferenceWithName(String name, ArrayObject arrayObject) {
        this.writeArrayImpl(name, arrayObject, true);
    }

    private void writeArrayImpl(String name, ArrayObject arrayObject, boolean reference) {
        this.startNewElement("Array");
        if (name != null) {
            this.setAttribute("_name", name);
        }
        this.setAttribute("_class", arrayObject.getComponentType().getName());
        this.setAttribute("size", Integer.toString(arrayObject.size()));
        this.writeArrayComponents(arrayObject, reference);
        this.finishCurrentElement();
    }

    private void writeArrayComponents(ArrayObject arrayObject, boolean reference) {
        try {
            int i = 0;
            while (i < arrayObject.size()) {
                Object comp = arrayObject.get(i);
                if (arrayObject.getComponentType().isPrimitive()) {
                    this.writePrimitive((PrimitiveObject)comp);
                } else if (reference) {
                    this.writeObjectAsReference(comp);
                } else {
                    this.writeObject(comp);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void writeAsMap(Map map) {
        try {
            this.getCurrentElement().removeAttribute("_id");
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                Object value = map.get(key);
                this.writeObject(key);
                this.writeObject(value);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void writeAsCollection(Collection collection) {
        try {
            this.getCurrentElement().removeAttribute("_id");
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                Object element = i.next();
                this.writeObject(element);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void writeFloat(float val) throws IOException {
        this.writePrimitive(new FloatObject(val));
    }

    public void writeInt(int val) throws IOException {
        this.writePrimitive(new IntObject(val));
    }

    public void writeLong(long val) throws IOException {
        this.writePrimitive(new LongObject(val));
    }

    public void writeShort(int val) throws IOException {
        this.writePrimitive(new ShortObject((short)val));
    }

    public void writeChar(int val) throws IOException {
        this.writePrimitive(new CharObject((char)val));
    }

    public void writeChars(String str) throws IOException {
        this.writePrimitive(new StringObject(str));
    }

    public void writeDouble(double val) throws IOException {
        this.writePrimitive(new DoubleObject(val));
    }

    public void writeBoolean(boolean val) throws IOException {
        this.writePrimitive(new BooleanObject(val));
    }

    public void writeByte(int val) throws IOException {
        this.writePrimitive(new ByteObject((byte)val));
    }

    protected void annotateClass(Class cl) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void annotateProxyClass(Class cl) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void drain() throws IOException {
        throw new UnsupportedOperationException();
    }

    protected boolean enableReplaceObject(boolean enable) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    public void flush() throws IOException {
        throw new UnsupportedOperationException();
    }

    public ObjectOutputStream.PutField putFields() throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Object replaceObject(Object obj) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void useProtocolVersion(int version) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] buf) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(int val) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeBytes(String str) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeFields() throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void writeStreamHeader() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeUnshared(Object obj) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeUTF(String str) throws IOException {
        throw new UnsupportedOperationException();
    }
}

