/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.io.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectInputStream;
import jp.ac.keio.sfc.crew.refrection.ClassObject;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLObjectReader {
    private InputStream inputStream;
    private ClassLoader classLoader = ClassLoader.getSystemClassLoader();

    public XMLObjectReader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public XMLObjectReader(InputStream inputStream, ClassLoader classLoader) {
        this.inputStream = inputStream;
        this.classLoader = classLoader;
    }

    public Object readObject() throws Exception {
        Document document = this.buildDocument();
        Object object = this.readObject(document);
        return object;
    }

    protected Document buildDocument() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource inputSource = new InputSource(new InputStreamReader(this.inputStream));
        Document document = builder.parse(inputSource);
        return document;
    }

    protected Object readObject(Document document) throws Exception {
        ClassLoader defaultLoader = ClassObject.getClassLoader();
        ClassObject.setClassLoader(this.classLoader);
        XMLObjectInputStream objectInputStream = new XMLObjectInputStream(document);
        Object object = objectInputStream.readObject();
        ClassObject.setClassLoader(defaultLoader);
        return object;
    }
}

