/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.refrection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import jp.ac.keio.sfc.crew.refrection.ArrayObject;
import jp.ac.keio.sfc.crew.refrection.ObjectObject;
import jp.ac.keio.sfc.crew.refrection.PrimitiveObject;
import jp.ac.keio.sfc.crew.refrection.WrapperObject;

public class ClassObject {
    public static final String CLASS_IDENTIFY_DELIMITER = "::";
    private static Map allInstances = new WeakHashMap();
    private static ClassLoader classLoader = new Object().getClass().getClassLoader();
    private Class clazz = null;
    private Map fields = new LinkedHashMap();
    private Map fieldKeys = new LinkedHashMap();
    private Map methods = new LinkedHashMap();
    private Map methodKeys = new LinkedHashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static void setClassLoader(ClassLoader loader) {
        if (loader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        classLoader = loader;
    }

    public static ClassObject lookup(Class clazz) {
        if (!allInstances.containsKey(clazz)) {
            allInstances.put(clazz, new ClassObject(clazz));
        }
        return (ClassObject)allInstances.get(clazz);
    }

    public static ClassObject forName(String FQCN) {
        try {
            Class<Comparable<Short>> clazz = null;
            clazz = FQCN.equals("short") ? Short.TYPE : (FQCN.equals("int") ? Integer.TYPE : (FQCN.equals("long") ? Long.TYPE : (FQCN.equals("float") ? Float.TYPE : (FQCN.equals("double") ? Double.TYPE : (FQCN.equals("byte") ? Byte.TYPE : (FQCN.equals("char") ? Character.TYPE : (FQCN.equals("boolean") ? Boolean.TYPE : Class.forName(FQCN, false, classLoader))))))));
            return ClassObject.lookup(clazz);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private ClassObject(Class clazz) {
        this.clazz = clazz;
        this.lookupFields();
        this.lookupMethods();
    }

    public WrapperObject newInstance() {
        try {
            if (this.isPrimitive()) {
                return PrimitiveObject.createObject(this.clazz);
            }
            if (this.isArray()) {
                return ArrayObject.createObject(this.clazz.getComponentType(), 0);
            }
            Object instance = this.newInstanceImpl();
            return new ObjectObject(instance);
        }
        catch (Exception ex) {
            throw new RuntimeException("cannot newInstance() in class = " + this.clazz, ex);
        }
    }

    private Object newInstanceImpl() throws Exception {
        Constructor<?>[] constructors = this.clazz.getDeclaredConstructors();
        Constructor<?> constructor = constructors[0];
        int i = 0;
        while (i < constructors.length) {
            if (constructor.getParameterTypes().length > constructors[i].getParameterTypes().length) {
                constructor = constructors[i];
            }
            ++i;
        }
        constructor.setAccessible(true);
        Class<?>[] classes = constructor.getParameterTypes();
        Object[] args = new Object[classes.length];
        int i2 = 0;
        while (i2 < classes.length) {
            ClassObject type = ClassObject.lookup(classes[i2]);
            if (type.isPrimitive()) {
                args[i2] = type.newInstance().getValue();
            }
            ++i2;
        }
        return constructor.newInstance(args);
    }

    public boolean isPrimitive() {
        if (this.clazz.isPrimitive()) {
            return true;
        }
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.clazz.equals(clazz);
    }

    public boolean isArray() {
        return this.clazz.isArray();
    }

    public Class getType() {
        return this.clazz;
    }

    private void lookupFields() {
        this.fields.clear();
        this.fieldKeys.clear();
        List fieldList = this.getFieldsRecursively(this.clazz);
        Iterator i = fieldList.iterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            String key = this.createFieldKey(field);
            Field value = field;
            this.fields.put(key, value);
            this.fieldKeys.put(value, key);
        }
    }

    private List getFieldsRecursively(Class clazz) {
        ArrayList fields = new ArrayList();
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            fields.addAll(this.getFieldsRecursively(superClass));
        }
        fields.addAll(this.getFields(clazz));
        return fields;
    }

    private List getFields(Class clazz) {
        Field[] fields = clazz.getDeclaredFields();
        return Arrays.asList(fields);
    }

    private String createFieldKey(Field field) {
        String name = field.getName();
        String key = !this.fields.containsKey(name) ? name : String.valueOf(field.getDeclaringClass().getName()) + CLASS_IDENTIFY_DELIMITER + name;
        return key;
    }

    private void lookupMethods() {
        this.methods.clear();
        this.methodKeys.clear();
        List methodList = this.getMethodsRecursively(this.clazz);
        Iterator i = methodList.iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            String key = this.createMethodKey(method);
            Method value = method;
            this.methods.put(key, value);
            this.methodKeys.put(value, key);
        }
    }

    private List getMethodsRecursively(Class clazz) {
        ArrayList methods = new ArrayList();
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            methods.addAll(this.getMethodsRecursively(superClass));
        }
        methods.addAll(this.getMethods(clazz));
        return methods;
    }

    private List getMethods(Class clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        return Arrays.asList(methods);
    }

    private String createMethodKey(Method method) {
        String name = method.getName();
        int counter = 0;
        String key = name;
        while (this.methods.containsKey(key)) {
            key = String.valueOf(name) + ++counter;
        }
        return key;
    }

    public String getFieldKey(Field field) {
        return (String)this.fieldKeys.get(field);
    }

    public Field getField(String key) {
        return (Field)this.fields.get(key);
    }

    public List getFields() {
        return new ArrayList(this.fields.values());
    }

    public List getFields(int denyModifiers) {
        ArrayList<Field> acceptedFields = new ArrayList<Field>();
        Iterator i = this.fields.values().iterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            if ((field.getModifiers() & denyModifiers) != 0) continue;
            acceptedFields.add(field);
        }
        return acceptedFields;
    }

    public String getMethodKey(Method method) {
        return (String)this.methodKeys.get(method);
    }

    public Method getMethod(String key) {
        return (Method)this.methods.get(key);
    }

    public List getMethods() {
        return new ArrayList(this.methods.values());
    }

    public List getMethods(int denyModifiers) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        Iterator i = this.methods.values().iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            if ((method.getModifiers() & denyModifiers) != 0) continue;
            methodList.add(method);
        }
        return methodList;
    }
}

