/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.refrection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ac.keio.sfc.crew.refrection.ClassObject;
import jp.ac.keio.sfc.crew.refrection.FieldObject;
import jp.ac.keio.sfc.crew.refrection.WrapperObject;

public class ObjectObject
extends WrapperObject {
    public static final int DEFAULT_DENY_MODIFIERS = 136;
    private int inspectionDenyModifiers = 136;
    private ClassObject clazz = null;
    private Object object = null;
    private Map fields = new LinkedHashMap();
    private Map attributes = new LinkedHashMap();

    public ObjectObject(Object instance) {
        this(instance, 136);
    }

    public ObjectObject(Object object, int inspectionDenyModifiers) {
        this.object = object;
        this.inspectionDenyModifiers = inspectionDenyModifiers;
        this.clazz = ClassObject.lookup(object.getClass());
        this.lookupFields();
    }

    private synchronized void lookupFields() {
        LinkedHashMap<String, FieldObject> newAttributes = new LinkedHashMap<String, FieldObject>();
        List fields = this.clazz.getFields(this.inspectionDenyModifiers);
        int i = 0;
        while (i < fields.size()) {
            Field field = (Field)fields.get(i);
            String key = this.clazz.getFieldKey(field);
            FieldObject value = new FieldObject(this, key, field);
            newAttributes.put(key, value);
            ++i;
        }
        this.fields = newAttributes;
    }

    public List getAllFields() {
        return new ArrayList(this.fields.values());
    }

    public Map getAttributes() {
        return new HashMap(this.attributes);
    }

    public void updateAttributes() {
        this.attributes.clear();
        List fields = this.getAllFields();
        int i = 0;
        while (i < fields.size()) {
            FieldObject field = (FieldObject)fields.get(i);
            Object value = field.getValue();
            if (value instanceof List) {
                List list = (List)value;
                int j = 0;
                while (j < list.size()) {
                    Object element = list.get(j);
                    this.attributes.put(String.valueOf(field.getName()) + "[" + j + "]", element);
                    ++j;
                }
            } else if (value instanceof Map) {
                Map map = (Map)value;
                Iterator j = map.keySet().iterator();
                while (j.hasNext()) {
                    Object key = j.next();
                    String keyStr = key.toString();
                    Object element = map.get(key);
                    this.attributes.put(String.valueOf(field.getName()) + "[" + keyStr + "]", element);
                }
            } else {
                this.attributes.put(field.getName(), value);
            }
            ++i;
        }
    }

    public Class getType() {
        return this.object.getClass();
    }

    public Object getValue() {
        return this.object;
    }

    public Object getValue(String key) {
        FieldObject field = this.getField(key);
        return this.getValue(field);
    }

    public Object getValue(FieldObject field) {
        return field.getValue();
    }

    public void setValue(String key, Object value) {
        FieldObject field = this.getField(key);
        field.setValue(value);
    }

    public Class getType(String key) {
        FieldObject field = this.getField(key);
        return field.getType();
    }

    public FieldObject getField(String key) {
        return (FieldObject)this.fields.get(key);
    }

    public boolean hasMethod(String name) {
        return this.hasMethod(name, new Class[0]);
    }

    public boolean hasMethod(String name, Class arg1) {
        return this.hasMethod(name, new Class[]{arg1});
    }

    public boolean hasMethod(String name, Class arg1, Class arg2) {
        return this.hasMethod(name, new Class[]{arg1, arg2});
    }

    public boolean hasMethod(String name, Class arg1, Class arg2, Class arg3) {
        return this.hasMethod(name, new Class[]{arg1, arg2, arg3});
    }

    public boolean hasMethod(String name, Class[] args) {
        return !this.getMethods(name, args).isEmpty();
    }

    public Object invokeMethod(String name) {
        return this.invokeMethod(name, new Class[0], new Object[0]);
    }

    public Object invokeMethod(String name, Class type1, Object arg1) {
        return this.invokeMethod(name, new Class[]{type1}, new Object[]{arg1});
    }

    public Object invokeMethod(String name, Class type1, Object arg1, Class type2, Object arg2) {
        return this.invokeMethod(name, new Class[]{type1, type2}, new Object[]{arg1, arg2});
    }

    public Object invokeMethod(String name, Class type1, Object arg1, Class type2, Object arg2, Class type3, Object arg3) {
        return this.invokeMethod(name, new Class[]{type1, type2, type3}, new Object[]{arg1, arg2, type3});
    }

    public Object invokeMethod(String name, Class[] types, Object[] args) {
        try {
            Method method = this.getMethod(name, types);
            method.setAccessible(true);
            return method.invoke(this.object, args);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Method getMethod(String name, Class[] args) {
        List methods = this.getMethods(name, args);
        return (Method)methods.get(methods.size() - 1);
    }

    private List getMethods(String name, Class[] argTypes) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        List methods = this.clazz.getMethods(this.inspectionDenyModifiers);
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            if (!method.getName().equals(name) || !Arrays.equals(method.getParameterTypes(), argTypes)) continue;
            methodList.add(method);
        }
        return methodList;
    }
}

