/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.swing.jface.objectinspector;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import jp.ac.keio.sfc.crew.swing.jface.objectinspector.ObjectInspectorViewerPanel;
import jp.ac.keio.sfc.crew.swing.jface.table.TablePanel;

public abstract class ObjectInspectableTablePanel
extends TablePanel {
    public ObjectInspectableTablePanel() {
        this.initialize();
    }

    protected void initialize() {
        this.getTable().setRowSelectionAllowed(false);
        this.getTable().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ObjectInspectableTablePanel.this.inspect();
                }
            }
        });
    }

    protected void inspect() {
        Object value;
        int row = this.getTable().getSelectedRow();
        int col = this.getTable().getSelectedColumn();
        if (row >= 0 && col >= 0 && (value = this.getTable().getModel().getValueAt(row, col)) != null) {
            this.openNewInspector(value);
        }
    }

    protected void openNewInspector(Object object) {
        JFrame frame = new JFrame(object.getClass().getName());
        frame.setDefaultCloseOperation(2);
        frame.setBounds(200, 200, 100, 100);
        ObjectInspectorViewerPanel viewer = new ObjectInspectorViewerPanel();
        viewer.setObject(object);
        frame.getContentPane().add(viewer);
        viewer.getTable().setPreferredScrollableViewportSize(viewer.getTable().getPreferredSize());
        frame.pack();
        frame.show();
    }
}

