/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.swing.jface.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jp.ac.keio.sfc.crew.swing.jface.wizard.WizardPage;

public abstract class Wizard
extends JDialog {
    private WizardPage firstWizardPage = null;
    private Stack pageStack = new Stack();
    private JButton nextButton = new JButton("Next>");
    private JButton backButton = new JButton("<Back");
    private JButton finishButton = new JButton("Finish");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel topPanel = new JPanel();
    private JPanel pagePanel = new JPanel();
    private JPanel bottomPanel = new JPanel();

    public Wizard() {
        this((Frame)null);
    }

    public Wizard(Frame owner) {
        super(owner, true);
        this.initializeComponents();
    }

    private void initializeComponents() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Wizard.this.goNext();
            }
        });
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Wizard.this.goBack();
            }
        });
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Wizard.this.finish();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Wizard.this.cancel();
            }
        });
        this.bottomPanel.setLayout(new FlowLayout(2));
        this.bottomPanel.add(this.backButton);
        this.bottomPanel.add(this.nextButton);
        this.bottomPanel.add(this.finishButton);
        this.bottomPanel.add(this.cancelButton);
        contentPane.add((Component)this.topPanel, "North");
        contentPane.add((Component)this.pagePanel, "Center");
        contentPane.add((Component)this.bottomPanel, "South");
    }

    public WizardPage getFirstWizardPage() {
        return this.firstWizardPage;
    }

    public void setFirstWizardPage(WizardPage page) {
        this.firstWizardPage = page;
    }

    public abstract WizardPage createFirstWizardPage();

    protected void refreshAllState() {
        this.refreshPageState();
        this.refreshButtonState();
        this.refreshBounds();
    }

    protected void refreshPageState() {
        this.getCurrentWizardPage().setWizard(this);
        this.pagePanel.removeAll();
        this.pagePanel.add(this.getCurrentWizardPage());
    }

    protected void refreshBounds() {
        this.pack();
        this.centerWindow();
    }

    protected void centerWindow() {
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        int x = center.x - this.getWidth() / 2;
        int y = center.y - this.getHeight() / 2;
        this.setLocation(x, y);
    }

    public void refreshButtonState() {
        if (this.getCurrentWizardPage().canGoNext()) {
            this.nextButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
        }
        if (this.getCurrentWizardPage() != this.getFirstWizardPage()) {
            this.backButton.setEnabled(true);
        } else {
            this.backButton.setEnabled(false);
        }
        if (this.getCurrentWizardPage().canFinish()) {
            this.finishButton.setEnabled(true);
        } else {
            this.finishButton.setEnabled(false);
        }
    }

    public void show() {
        this.startWizard();
        super.show();
    }

    private void startWizard() {
        this.initializeWizard();
        this.initializePage();
    }

    private void initializeWizard() {
        this.pageStack.removeAllElements();
        this.setFirstWizardPage(this.createFirstWizardPage());
    }

    public WizardPage getCurrentWizardPage() {
        return (WizardPage)this.pageStack.peek();
    }

    private void initializePage() {
        this.pageStack.push(this.getFirstWizardPage());
        this.refreshAllState();
    }

    private void goNext() {
        this.pageStack.push(this.getCurrentWizardPage().getNextWizardPage());
        this.refreshAllState();
    }

    private void goBack() {
        this.pageStack.pop();
        this.refreshAllState();
    }

    private void finish() {
        int i = 0;
        while (i < this.pageStack.size()) {
            WizardPage page = (WizardPage)this.pageStack.get(i);
            page.finishPage();
            ++i;
        }
        this.dispose();
    }

    private void cancel() {
        this.dispose();
    }
}

