/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFStream;

public class PDFICCStream
extends PDFStream {
    private int origLength;
    private int len1;
    private int len3;
    private ICC_Profile cp = null;
    private PDFColorSpace pdfColorSpace;

    public PDFICCStream(int num) {
        super(num);
    }

    public void setColorSpace(ICC_Profile cp, PDFColorSpace alt) {
        this.cp = cp;
        this.pdfColorSpace = alt;
    }

    protected int output(OutputStream stream) throws IOException {
        this.setData(this.cp.getData());
        int length = 0;
        String filterEntry = this.applyFilters();
        StringBuffer pb = new StringBuffer();
        pb.append(this.number).append(" ").append(this.generation).append(" obj\n<< ");
        pb.append("/N ").append(this.cp.getNumComponents()).append(" ");
        if (this.pdfColorSpace != null) {
            pb.append("/Alternate /").append(this.pdfColorSpace.getColorSpacePDFString()).append(" ");
        }
        pb.append("/Length ").append(this.data.getSize() + 1).append(" ").append(filterEntry);
        pb.append(" >>\n");
        byte[] p = pb.toString().getBytes();
        stream.write(p);
        length += p.length;
        length += this.outputStreamData(stream);
        p = "endobj\n".getBytes();
        stream.write(p);
        return length += p.length;
    }
}

