/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.fop.pdf.PDFObject;

public class PDFInfo
extends PDFObject {
    private String producer;
    private String title = null;
    private String author = null;
    private String subject = null;
    private String keywords = null;
    private String creator;

    public PDFInfo(int number) {
        super(number);
    }

    public void setProducer(String producer) {
        this.producer = producer;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public void setAuthor(String a) {
        this.author = a;
    }

    public void setSubject(String s) {
        this.subject = s;
    }

    public void setKeywords(String k) {
        this.keywords = k;
    }

    public byte[] toPDF() {
        String p = this.number + " " + this.generation + " obj\n<< /Type /Info\n";
        if (this.title != null) {
            p = p + "/Title (" + this.title + ")\n";
        }
        if (this.author != null) {
            p = p + "/Author (" + this.author + ")\n";
        }
        if (this.subject != null) {
            p = p + "/Subject (" + this.subject + ")\n";
        }
        if (this.keywords != null) {
            p = p + "/Keywords (" + this.keywords + ")\n";
        }
        if (this.creator != null) {
            p = p + "/Creator (" + this.creator + ")\n";
        }
        p = p + "/Producer (" + this.producer + ")\n";
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
        String str = sdf.format(date) + "+00'00'";
        p = p + "/CreationDate (D:" + str + ")";
        p = p + " >>\nendobj\n";
        return p.getBytes();
    }
}

