/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.TransitionDictionary;

public class PDFPage
extends PDFResourceContext {
    protected String parent;
    protected PDFStream contents;
    protected int pagewidth;
    protected int pageheight;
    protected int duration = -1;
    protected TransitionDictionary trDictionary = null;

    public PDFPage(PDFDocument doc, int number, PDFResources resources, PDFStream contents, int pagewidth, int pageheight) {
        super(number, doc, resources);
        this.contents = contents;
        this.pagewidth = pagewidth;
        this.pageheight = pageheight;
    }

    public PDFPage(PDFDocument doc, int number, PDFResources resources, int pagewidth, int pageheight) {
        super(number, doc, resources);
        this.pagewidth = pagewidth;
        this.pageheight = pageheight;
    }

    public void setContents(PDFStream contents) {
        this.contents = contents;
    }

    public void setParent(PDFPages parent) {
        this.parent = parent.referencePDF();
    }

    public void setTransition(int dur, TransitionDictionary tr) {
        this.duration = dur;
        this.trDictionary = tr;
    }

    public byte[] toPDF() {
        StringBuffer sb = new StringBuffer();
        sb = sb.append(this.number + " " + this.generation + " obj\n" + "<< /Type /Page\n" + "/Parent " + this.parent + "\n" + "/MediaBox [ 0 0 " + this.pagewidth + " " + this.pageheight + " ]\n" + "/Resources " + this.resources.referencePDF() + "\n" + "/Contents " + this.contents.referencePDF() + "\n");
        if (this.annotList != null) {
            sb = sb.append("/Annots " + this.annotList.referencePDF() + "\n");
        }
        if (this.duration != -1) {
            sb = sb.append("/Dur " + this.duration + "\n");
        }
        if (this.trDictionary != null) {
            sb = sb.append("/Trans << " + this.trDictionary.getDictionary() + " >>\n");
        }
        sb = sb.append(">>\nendobj\n");
        return sb.toString().getBytes();
    }
}

