/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFXObject;

public class PDFResources
extends PDFObject {
    protected Map fonts = new HashMap();
    protected Set xObjects = new HashSet();
    protected Set patterns = new HashSet();
    protected Set shadings = new HashSet();
    protected Set gstates = new HashSet();

    public PDFResources(int number) {
        super(number);
    }

    public void addFont(PDFFont font) {
        this.fonts.put(font.getName(), font);
    }

    public void addGState(PDFGState gs) {
        this.gstates.add(gs);
    }

    public void addShading(PDFShading theShading) {
        this.shadings.add(theShading);
    }

    public void addPattern(PDFPattern thePattern) {
        this.patterns.add(thePattern);
    }

    public void addXObject(PDFXObject xObject) {
        this.xObjects.add(xObject);
    }

    public byte[] toPDF() {
        Iterator iter;
        StringBuffer p = new StringBuffer(this.number + " " + this.generation + " obj\n<< \n");
        if (!this.fonts.isEmpty()) {
            p.append("/Font << ");
            Iterator fontIterator = this.fonts.keySet().iterator();
            while (fontIterator.hasNext()) {
                String fontName = (String)fontIterator.next();
                p.append("/" + fontName + " " + ((PDFFont)this.fonts.get(fontName)).referencePDF() + " ");
            }
            p.append(">> \n");
        }
        PDFShading currentShading = null;
        if (!this.shadings.isEmpty()) {
            p.append("/Shading << ");
            Iterator iter2 = this.shadings.iterator();
            while (iter2.hasNext()) {
                currentShading = (PDFShading)iter2.next();
                p.append("/" + currentShading.getName() + " " + currentShading.referencePDF() + " ");
            }
            p.append(">>\n");
        }
        currentShading = null;
        PDFPattern currentPattern = null;
        if (!this.patterns.isEmpty()) {
            p.append("/Pattern << ");
            iter = this.patterns.iterator();
            while (iter.hasNext()) {
                currentPattern = (PDFPattern)iter.next();
                p.append("/" + currentPattern.getName() + " " + currentPattern.referencePDF() + " ");
            }
            p.append(">> \n");
        }
        currentPattern = null;
        p.append("/ProcSet [ /PDF /ImageC /Text ]\n");
        if (this.xObjects != null && !this.xObjects.isEmpty()) {
            p = p.append("/XObject <<");
            iter = this.xObjects.iterator();
            while (iter.hasNext()) {
                PDFXObject xobj = (PDFXObject)iter.next();
                p = p.append("/Im" + xobj.getXNumber() + " " + xobj.referencePDF() + "\n");
            }
            p = p.append(" >>\n");
        }
        if (!this.gstates.isEmpty()) {
            p = p.append("/ExtGState <<");
            iter = this.gstates.iterator();
            while (iter.hasNext()) {
                PDFGState gs = (PDFGState)iter.next();
                p = p.append("/" + gs.getName() + " " + gs.referencePDF() + " ");
            }
            p = p.append(">>\n");
        }
        p = p.append(">>\nendobj\n");
        return p.toString().getBytes();
    }
}

