/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.fop.pdf.ASCII85Filter;
import org.apache.fop.pdf.ASCIIHexFilter;
import org.apache.fop.pdf.FlateFilter;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.StreamCache;

public class PDFStream
extends PDFObject {
    public static final String DEFAULT_FILTER = "default";
    public static final String CONTENT_FILTER = "content";
    public static final String IMAGE_FILTER = "image";
    public static final String JPEG_FILTER = "jpeg";
    public static final String FONT_FILTER = "font";
    protected StreamCache data;
    private List filters;

    public PDFStream(int number) {
        super(number);
        try {
            this.data = StreamCache.createStreamCache();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.filters = new ArrayList();
    }

    public void add(String s) {
        try {
            this.data.getOutputStream().write(s.getBytes());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void addFilter(PDFFilter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    public void addFilter(String filterType) {
        if (filterType == null) {
            return;
        }
        if (filterType.equals("flate")) {
            this.addFilter(new FlateFilter());
        } else if (filterType.equals("ascii-85")) {
            this.addFilter(new ASCII85Filter());
        } else if (filterType.equals("ascii-hex")) {
            this.addFilter(new ASCIIHexFilter());
        } else {
            if (filterType.equals("")) {
                return;
            }
            throw new IllegalArgumentException("Unsupported filter type in stream-filter-list: " + filterType);
        }
    }

    public void addDefaultFilters(Map filters, String type) {
        List filterset = (List)filters.get(type);
        if (filterset == null) {
            filterset = (List)filters.get(DEFAULT_FILTER);
        }
        if (filterset != null && filterset.size() != 0) {
            int i = 0;
            while (i < filterset.size()) {
                String v = (String)filterset.get(i);
                this.addFilter(v);
                ++i;
            }
        }
    }

    public void addImageArray(int[] pixels, int width, int height) {
        try {
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int p = pixels[i * width + j];
                    int r = p >> 16 & 0xFF;
                    int g = p >> 8 & 0xFF;
                    int b = p & 0xFF;
                    if (r < 16) {
                        this.data.getOutputStream().write(48);
                    }
                    this.data.getOutputStream().write(Integer.toHexString(r).getBytes());
                    if (g < 16) {
                        this.data.getOutputStream().write(48);
                    }
                    this.data.getOutputStream().write(Integer.toHexString(g).getBytes());
                    if (b < 16) {
                        this.data.getOutputStream().write(48);
                    }
                    this.data.getOutputStream().write(Integer.toHexString(b).getBytes());
                    this.data.getOutputStream().write(32);
                    ++j;
                }
                ++i;
            }
            this.data.getOutputStream().write(">\n".getBytes());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setData(byte[] data) throws IOException {
        this.data.reset();
        this.data.getOutputStream().write(data);
    }

    public int getDataLength() {
        try {
            return this.data.getSize();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public byte[] toPDF() {
        throw new UnsupportedOperationException("Use output(OutputStream) instead");
    }

    protected int output(OutputStream stream) throws IOException {
        int length = 0;
        String filterEntry = this.applyFilters();
        byte[] p = (this.number + " " + this.generation + " obj\n<< /Length " + (this.data.getSize() + 1) + " " + filterEntry + " >>\n").getBytes();
        stream.write(p);
        length += p.length;
        length += this.outputStreamData(stream);
        p = "endobj\n".getBytes();
        stream.write(p);
        return length += p.length;
    }

    protected int outputStreamData(OutputStream stream) throws IOException {
        int length = 0;
        byte[] p = "stream\n".getBytes();
        stream.write(p);
        length += p.length;
        this.data.outputStreamData(stream);
        length += this.data.getSize();
        this.data.close();
        p = "\nendstream\n".getBytes();
        stream.write(p);
        return length += p.length;
    }

    protected String applyFilters() throws IOException {
        if (this.filters.size() > 0) {
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> parms = new ArrayList<String>();
            int count = 0;
            while (count < this.filters.size()) {
                PDFFilter filter = (PDFFilter)this.filters.get(count);
                if (!filter.isApplied()) {
                    this.data.applyFilter(filter);
                    filter.setApplied(true);
                }
                names.add(0, filter.getName());
                parms.add(0, filter.getDecodeParms());
                ++count;
            }
            return this.buildFilterEntries(names) + this.buildDecodeParms(parms);
        }
        return "";
    }

    private String buildFilterEntries(List names) {
        StringBuffer sb = new StringBuffer();
        sb.append("/Filter ");
        if (names.size() > 1) {
            sb.append("[ ");
        }
        int count = 0;
        while (count < names.size()) {
            sb.append((String)names.get(count));
            sb.append(" ");
            ++count;
        }
        if (names.size() > 1) {
            sb.append("]");
        }
        sb.append("\n");
        return sb.toString();
    }

    private String buildDecodeParms(List parms) {
        StringBuffer sb = new StringBuffer();
        boolean needParmsEntry = false;
        sb.append("/DecodeParms ");
        if (parms.size() > 1) {
            sb.append("[ ");
        }
        int count = 0;
        while (count < parms.size()) {
            String s = (String)parms.get(count);
            if (s != null) {
                sb.append(s);
                needParmsEntry = true;
            } else {
                sb.append("null");
            }
            sb.append(" ");
            ++count;
        }
        if (parms.size() > 1) {
            sb.append("]");
        }
        sb.append("\n");
        if (needParmsEntry) {
            return sb.toString();
        }
        return "";
    }
}

