/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import org.apache.fop.area.CTM;

public final class CTMHelper {
    public static String toPDFString(CTM sourceMatrix) {
        if (null == sourceMatrix) {
            throw new NullPointerException("sourceMatrix must not be null");
        }
        double[] matrix = CTMHelper.toPDFArray(sourceMatrix);
        return matrix[0] + " " + matrix[1] + " " + matrix[2] + " " + matrix[3] + " " + matrix[4] + " " + matrix[5];
    }

    public static CTM toPDFCTM(CTM sourceMatrix) {
        if (null == sourceMatrix) {
            throw new NullPointerException("sourceMatrix must not be null");
        }
        double[] matrix = CTMHelper.toPDFArray(sourceMatrix);
        return new CTM(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
    }

    public static double[] toPDFArray(CTM sourceMatrix) {
        if (null == sourceMatrix) {
            throw new NullPointerException("sourceMatrix must not be null");
        }
        double[] matrix = sourceMatrix.toArray();
        return new double[]{matrix[0], matrix[1], matrix[2], matrix[3], matrix[4] / 1000.0, matrix[5] / 1000.0};
    }
}

