/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class StreamUtilities {
    public static final int BUFFER_SIZE = 4096;

    /*
     * WARNING - void declaration
     */
    public static long streamCopy(InputStream source, OutputStream sink) throws IOException {
        int scoop;
        byte[] buffer = new byte[4096];
        long total = 0L;
        while ((scoop = source.read(buffer)) >= 0) {
            void var5_4;
            if (var5_4 == false) {
                System.out.println("zero scoop!");
            }
            sink.write(buffer, 0, (int)var5_4);
            total += (long)var5_4;
        }
        sink.flush();
        return total;
    }

    public static long streamCopy(InputStream source, OutputStream sink, int howMany) throws IOException {
        byte[] buffer = new byte[4096];
        int left = howMany;
        while (left > 0) {
            int scoop = source.read(buffer, 0, Math.min(4096, left));
            if (scoop < 0) {
                throw new EOFException("Not enough bytes to feed you in IOLib.streamCopy(source, sink, howMany); you asked for " + howMany + " and I only have " + (howMany - left));
            }
            sink.write(buffer, 0, scoop);
            left -= scoop;
        }
        sink.flush();
        return howMany;
    }

    public static long streamCopyWithChecksum(InputStream source, OutputStream sink, int howMany) throws IOException {
        byte[] buffer = new byte[4096];
        int left = howMany;
        CRC32 checksummer = new CRC32();
        while (left > 0) {
            int scoop = source.read(buffer, 0, Math.min(4096, left));
            if (scoop < 0) {
                throw new EOFException("Not enough bytes to feed you in IOLib.streamCopy(source, sink, howMany)");
            }
            checksummer.update(buffer, 0, scoop);
            sink.write(buffer, 0, scoop);
            left -= scoop;
        }
        sink.flush();
        return checksummer.getValue();
    }

    public static long dataCopy(DataInput source, DataOutput sink, int howMany) throws IOException {
        byte[] buffer = new byte[4096];
        int left = howMany;
        while (left > 0) {
            int scoop = Math.min(4096, left);
            source.readFully(buffer, 0, scoop);
            sink.write(buffer, 0, scoop);
            left -= scoop;
        }
        return howMany;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream in, int initialTargetBufferSize) throws IOException {
        ByteArrayOutputStream baout = new ByteArrayOutputStream(initialTargetBufferSize);
        try {
            StreamUtilities.streamCopy(in, baout);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            baout.close();
            throw throwable;
        }
        baout.close();
        return baout.toByteArray();
    }
}

