/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.slideshow;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JWindow;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class Main
extends JComponent {
    StaticRenderer renderer;
    UserAgent userAgent;
    DocumentLoader loader;
    BridgeContext ctx;
    BufferedImage image;
    BufferedImage display;
    File[] files;
    static int duration = 3000;
    static int frameDelay = duration + 7000;
    boolean done = false;
    Thread transitionThread = null;
    long startLastTransition = 0L;
    boolean paused = false;

    public Main(File[] fileArray, Dimension dimension) {
        this.setBackground(Color.black);
        this.files = fileArray;
        this.renderer = new StaticRenderer();
        this.userAgent = new UserAgentAdapter();
        this.loader = new DocumentLoader(this.userAgent);
        this.ctx = new BridgeContext(this.userAgent, this.loader);
        boolean bl = false;
        if (dimension == null) {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
            bl = true;
        }
        this.setPreferredSize(dimension);
        this.setDoubleBuffered(false);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (Main.this.done) {
                    System.exit(0);
                } else {
                    Main.this.togglePause();
                }
            }
        });
        dimension.width += 2;
        dimension.height += 2;
        this.display = new BufferedImage(dimension.width, dimension.height, 4);
        RenderThread renderThread = new RenderThread();
        renderThread.start();
        JWindow jWindow = new JWindow();
        ((Component)jWindow).setBackground(Color.black);
        jWindow.getContentPane().setBackground(Color.black);
        jWindow.getContentPane().add(this);
        jWindow.pack();
        ((Component)jWindow).setLocation(new Point(-1, -1));
        ((Component)jWindow).setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTransition(BufferedImage bufferedImage) {
        Main main = this;
        synchronized (main) {
            while (this.transitionThread != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.transitionThread = new TransitionThread(bufferedImage);
            this.transitionThread.start();
            return;
        }
    }

    public void togglePause() {
        Main main = this;
        synchronized (main) {
            Cursor cursor;
            boolean bl = this.paused = !this.paused;
            if (this.paused) {
                cursor = new Cursor(3);
            } else {
                cursor = new Cursor(0);
                if (this.transitionThread != null) {
                    Thread thread = this.transitionThread;
                    synchronized (thread) {
                        this.transitionThread.notifyAll();
                    }
                }
            }
            this.setCursor(cursor);
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.display == null) {
            return;
        }
        graphics2D.drawImage(this.display, null, 0, 0);
    }

    public static void readFileList(String string, Vector vector) {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Unable to open file-list: " + string);
            return;
        }
        try {
            String string2;
            URL uRL = new File(string).toURL();
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3 = string2;
                int n = string3.indexOf(35);
                if (n != -1) {
                    string3 = string3.substring(0, n);
                }
                string3.trim();
                if (string3.length() == 0) continue;
                try {
                    URL uRL2 = new URL(uRL, string3);
                    vector.add(uRL2.getFile());
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("Can't make sense of line:\n  " + string2);
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Error while reading file-list: " + string);
        }
    }

    public static void main(String[] stringArray) {
        int n;
        Vector<String> vector = new Vector<String>();
        Dimension dimension = null;
        if (stringArray.length == 0) {
            Main.showUsage();
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-h") || stringArray[n2].equals("-help") || stringArray[n2].equals("--help")) {
                Main.showUsage();
                return;
            }
            if (stringArray[n2].equals("--")) {
                ++n2;
                while (n2 < stringArray.length) {
                    vector.add(stringArray[n2++]);
                }
                break;
            }
            if (stringArray[n2].equals("-fl") || stringArray[n2].equals("--file-list")) {
                if (n2 + 1 == stringArray.length) {
                    System.err.println("Must provide name of file list file after " + stringArray[n2]);
                    break;
                }
                Main.readFileList(stringArray[n2 + 1], vector);
                ++n2;
            } else if (stringArray[n2].equals("-ft") || stringArray[n2].equals("--frame-time")) {
                if (n2 + 1 == stringArray.length) {
                    System.err.println("Must provide time in millis after " + stringArray[n2]);
                    break;
                }
                try {
                    frameDelay = Integer.decode(stringArray[n2 + 1]);
                    ++n2;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't parse frame time: " + stringArray[n2 + 1]);
                }
            } else if (stringArray[n2].equals("-tt") || stringArray[n2].equals("--transition-time")) {
                if (n2 + 1 == stringArray.length) {
                    System.err.println("Must provide time in millis after " + stringArray[n2]);
                    break;
                }
                try {
                    duration = Integer.decode(stringArray[n2 + 1]);
                    ++n2;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't parse transition time: " + stringArray[n2 + 1]);
                }
            } else if (stringArray[n2].equals("-ws") || stringArray[n2].equals("--window-size")) {
                if (n2 + 1 == stringArray.length) {
                    System.err.println("Must provide window size [w,h] after " + stringArray[n2]);
                    break;
                }
                try {
                    int n3;
                    int n4 = stringArray[n2 + 1].indexOf(44);
                    if (n4 == -1) {
                        n = n3 = Integer.decode(stringArray[n2 + 1]).intValue();
                    } else {
                        String string = stringArray[n2 + 1].substring(0, n4);
                        String string2 = stringArray[n2 + 1].substring(n4 + 1);
                        n = Integer.decode(string);
                        n3 = Integer.decode(string2);
                    }
                    dimension = new Dimension(n, n3);
                    ++n2;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't parse window size: " + stringArray[n2 + 1]);
                }
            } else {
                vector.add(stringArray[n2]);
            }
            ++n2;
        }
        File[] fileArray = new File[vector.size()];
        n = 0;
        while (n < vector.size()) {
            try {
                fileArray[n] = new File((String)vector.get(n));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
        new Main(fileArray, dimension);
    }

    public static void showUsage() {
        System.out.println("Options:\n                                 -- : Remaining args are file names\n                         -fl <file>\n                 --file-list <file> : file contains list of images to\n                                      show one per line\n             -ws <width>[,<height>]\n    -window-size <width>[,<height>] : Set the size of slideshow window\n                                      defaults to full screen\n                          -ft <int>\n                 --frame-time <int> : Amount of time in millisecs to\n                                      show each frame.\n                                      Includes transition time.\n                          -tt <int>\n            --transition-time <int> : Amount of time in millisecs to\n                                      transition between frames.\n                             <file> : SVG file to display");
    }

    class TransitionThread
    extends Thread {
        BufferedImage src;
        int blockw = 75;
        int blockh = 75;

        public TransitionThread(BufferedImage bufferedImage) {
            this.src = bufferedImage;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            int n = (Main.this.display.getWidth() + this.blockw - 1) / this.blockw;
            int n2 = (Main.this.display.getHeight() + this.blockh - 1) / this.blockh;
            int n3 = n * n2;
            int n4 = duration / n3;
            Point[] pointArray = new Point[n3];
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n) {
                    pointArray[n5 * n + n6] = new Point(n6, n5);
                    ++n6;
                }
                ++n5;
            }
            Graphics2D graphics2D = Main.this.display.createGraphics();
            graphics2D.setColor(new Color(0, 0, 0));
            long l = System.currentTimeMillis();
            while (l - Main.this.startLastTransition < (long)frameDelay) {
                try {
                    long l2 = (long)frameDelay - (l - Main.this.startLastTransition);
                    if (l2 > 500L) {
                        System.gc();
                        l = System.currentTimeMillis();
                        l2 = (long)frameDelay - (l - Main.this.startLastTransition);
                    }
                    if (l2 > 0L) {
                        Thread.sleep(l2);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l = System.currentTimeMillis();
            }
            TransitionThread transitionThread = this;
            synchronized (transitionThread) {
                while (Main.this.paused) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            long l3 = Main.this.startLastTransition = System.currentTimeMillis();
            int n7 = 0;
            while (n7 < pointArray.length) {
                int n8 = (int)(Math.random() * (double)(pointArray.length - n7));
                Point point = pointArray[n8];
                int n9 = n8 + 1;
                while (n9 < pointArray.length - n7) {
                    pointArray[n9 - 1] = pointArray[n9];
                    ++n9;
                }
                int n10 = point.x * this.blockw;
                int n11 = point.y * this.blockh;
                int n12 = this.blockw;
                int n13 = this.blockh;
                if (n10 + n12 > this.src.getWidth()) {
                    n12 = this.src.getWidth() - n10;
                }
                if (n11 + n13 > this.src.getHeight()) {
                    n13 = this.src.getHeight() - n11;
                }
                BufferedImage bufferedImage = Main.this.display;
                synchronized (bufferedImage) {
                    graphics2D.fillRect(n10, n11, n12, n13);
                    BufferedImage bufferedImage2 = this.src.getSubimage(n10, n11, n12, n13);
                    graphics2D.drawImage(bufferedImage2, null, n10, n11);
                }
                Main.this.repaint(n10, n11, n12, n13);
                long l4 = System.currentTimeMillis();
                try {
                    long l5 = l4 - l3;
                    if (l5 < (long)n4) {
                        Thread.sleep((long)n4 - l5);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l3 = l4;
                ++n7;
            }
            Main main = Main.this;
            synchronized (main) {
                Main.this.transitionThread = null;
                Main.this.notifyAll();
                return;
            }
        }
    }

    class RenderThread
    extends Thread {
        RenderThread() {
        }

        public void run() {
            Main.this.renderer.setDoubleBuffered(true);
            int n = 0;
            while (n < Main.this.files.length) {
                GraphicsNode graphicsNode = null;
                GVTBuilder gVTBuilder = new GVTBuilder();
                try {
                    System.out.println("Reading: " + Main.this.files[n]);
                    Document document = Main.this.loader.loadDocument(Main.this.files[n].toURL().toString());
                    System.out.println("Building: " + Main.this.files[n]);
                    graphicsNode = gVTBuilder.build(Main.this.ctx, document);
                    System.out.println("Rendering: " + Main.this.files[n]);
                    Main.this.renderer.setTree(graphicsNode);
                    SVGSVGElement sVGSVGElement = ((SVGDocument)document).getRootElement();
                    Main.this.renderer.setTransform(ViewBox.getViewTransform(null, (Element)sVGSVGElement, (float)Main.this.display.getWidth(), (float)Main.this.display.getHeight()));
                    Main.this.renderer.updateOffScreen(Main.this.display.getWidth(), Main.this.display.getHeight());
                    Rectangle rectangle = new Rectangle(0, 0, Main.this.display.getWidth(), Main.this.display.getHeight());
                    Main.this.renderer.repaint((Shape)rectangle);
                    System.out.println("Painting: " + Main.this.files[n]);
                    Main.this.image = Main.this.renderer.getOffScreen();
                    Main.this.setTransition(Main.this.image);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                ++n;
            }
            if (Main.this.transitionThread != null) {
                try {
                    Main.this.transitionThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Main.this.done = true;
                Main.this.setCursor(new Cursor(3));
            }
        }
    }
}

