/*
 * Created on 2004/06/02
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package happybirthday;

import happybirthday.HiroseYuukoModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.AbstractInformation;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Goods;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.components.stepclock.StepClock;

/**
 * birthdayWorld
 */
public class birthdayWorld extends World {

	/*************************************
	 * Class variable and main method for running on the besp
	 *************************************/
	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(birthdayWorld.class.getName());

	public static void main(String[] args) {
		BESP.main(new String[] { "-model", birthdayWorld.class.getName()});
	}

	/*************************************
	 * Parameters
	 *************************************/

	//List of agents created from AgentGroup
	private List mothers = new ArrayList();
	private List childrens = new ArrayList();
	private List flowerStores = new ArrayList();

	/*************************************
	 * Initialize
	 *************************************/

	/**
	 * Initialize World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#initializeWorld()
	 */
	public void initializeWorld() {
		logger.info("Initialize World.");
		super.initializeWorld();

		//set the clock
		this.setClock(new StepClock());
	}

	/**
	 *  Initialize Agents.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#initializeAgents()
	 */
	public void initializeAgents() {
		logger.info(" Initialize Agents.");
		super.initializeAgents();

		this.createAgents();
		this.addRelations();
		this.initializeByHands();
	}

	/**
	 * this method is not overrided for automaticaly.
	 */
	private void initializeByHands() {
	}

	/**
	 * Create Agents.
	 */
	private void createAgents() {
		logger.info("Create Agents.");

		this.createMotherAgent();
		this.createChildrenAgent();
		this.createFlowerStoreAgent();
	}

	/**
	 * Add Relations
	 */
	private void addRelations() {
		logger.info("Add Relations");

		this.addFamilyRelationRelations();
		this.addFavoriteFlowerStoreRelationRelations();
	}

	/*************************************
	 * Subroutines to create agents
	 *************************************/

	/**
	 * Create Mother Agent
	 */
	private void createMotherAgent() {
		logger.info("Create Mother Agent");

		//create agent
		Agent agentMother =
			super.createAgent(HiroseYuukoModel.AGENTTYPE_Mother);

		//add behavior(s)
		agentMother.addBehavior(
			HiroseYuukoModel.BEHAVIORTYPE_SayingThanksBehavior);

		mothers.add(agentMother);
	}

	/**
	 * Create Children Agent
	 */
	private void createChildrenAgent() {
		logger.info("Create Children Agent");

		//create agent
		Agent agentChildren =
			super.createAgent(HiroseYuukoModel.AGENTTYPE_Children);

		//add behavior(s)
		agentChildren.addBehavior(
			HiroseYuukoModel.BEHAVIORTYPE_SayingCongratulationBehavior);
		agentChildren.addBehavior(
			HiroseYuukoModel.BEHAVIORTYPE_ShopingBehavior);

		//add goods
		Goods goodsGOODSTYPE_MoneyGoods =
			super.createGoods(HiroseYuukoModel.GOODSTYPE_MoneyGoods, 0);
		agentChildren.addGoods(goodsGOODSTYPE_MoneyGoods);

		childrens.add(agentChildren);
	}

	/**
	 * Create FlowerStore Agent
	 */
	private void createFlowerStoreAgent() {
		logger.info("Create FlowerStore Agent");

		//create agent
		Agent agentFlowerStore =
			super.createAgent(HiroseYuukoModel.AGENTTYPE_FlowerStore);

		//add behavior(s)
		agentFlowerStore.addBehavior(
			HiroseYuukoModel.BEHAVIORTYPE_SalesBehavior);

		//add goods
		Goods goodsGOODSTYPE_MoneyGoods =
			super.createGoods(HiroseYuukoModel.GOODSTYPE_MoneyGoods, 5000);
		agentFlowerStore.addGoods(goodsGOODSTYPE_MoneyGoods);
		Goods goodsGOODSTYPE_FlowerGoods =
			super.createGoods(HiroseYuukoModel.GOODSTYPE_FlowerGoods, 1);
		agentFlowerStore.addGoods(goodsGOODSTYPE_FlowerGoods);

		//put information
		agentFlowerStore.putInformation(new AbstractInformation());

		flowerStores.add(agentFlowerStore);
	}

	/*************************************
	 * Subroutines to add relations
	 *************************************/

	/**
	 * add FamilyRelation relations
	 */
	private void addFamilyRelationRelations() {
		logger.info("add FamilyRelation relations");

		//set the source and target agents
		List sourceAgents = new ArrayList(childrens);
		List targetAgents = new ArrayList(mothers);

		//Add Relations
		Agent sourceAgent = (Agent) sourceAgents.get(0);
		Agent targetAgent = (Agent) targetAgents.get(0);

		if (sourceAgent != targetAgent) {
			//add relation from source to target
			sourceAgent.addRelation(
				HiroseYuukoModel.RELATIONTYPE_familyRelation,
				targetAgent);
			//add reverse relation from target to source
			targetAgent.addRelation(
				HiroseYuukoModel.RELATIONTYPE_familyRelation,
				sourceAgent);
		}

	}

	/**
	 * add FavoriteFlowerStoreRelation relations
	 */
	private void addFavoriteFlowerStoreRelationRelations() {
		logger.info("add FavoriteFlowerStoreRelation relations");

		//set the source and target agents
		List sourceAgents = new ArrayList(childrens);
		List targetAgents = new ArrayList(flowerStores);

		//Add Relations
		Agent sourceAgent = (Agent) sourceAgents.get(0);
		Agent targetAgent = (Agent) targetAgents.get(0);

		if (sourceAgent != targetAgent) {
			//add relation from source to target
			sourceAgent.addRelation(
				HiroseYuukoModel.RELATIONTYPE_favoriteFlowerStoreRelation,
				targetAgent);
		}

	}

	/*************************************
	 * Name and Desctription for World
	 *************************************/

	/**
	 * Returns the description of World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#getDescription()
	 */
	public String getName() {
		return "birthdayWorld";
	}

	/**
	 * Returns the name of World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#getName()
	 */
	public String getDescription() {
		return "";
	}

	/*************************************
	 * Utility methods for generating random number
	 *************************************/

	/**
	 * Generate random number by double.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private double generateRandomNumberByDouble(
		String generatorName,
		double max,
		double minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		double result = minimum + randomNumber * (max - minimum);

		return result;
	}

	/**
	 * Generate random number by int.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private int generateRandomNumberByInt(
		String generatorName,
		int max,
		int minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		int result = (int) (minimum + randomNumber * (max - minimum));

		return result;
	}

	/**
	 * Generate random number by long.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private long generateRandomNumberByLong(
		String generatorName,
		long max,
		long minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		long result = (long) (minimum + randomNumber * (max - minimum));

		return result;
	}

	/**
	 * generate elected numbers excluded the value at random
	 * 
	 * @param key of random number generator
	 * @param number of elected one
	 * @param max
	 * @param exclude number
	 * @return elected numbers
	 */
	private int[] generateElectedRandomNumbers(
		String generatorName,
		int number,
		int max,
		int excludedNumber) {
		assert(number < max);
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);
		int[] electedNumbers = new int[number];
		Arrays.fill(electedNumbers, -1);

		//generate elected number
		for (int i = 0; i < number; i++) {
			int generatedNumber;
			if (excludedNumber >= 0) {
				generatedNumber = generator.generate(max - 1);
				//exclude the number
				if (generatedNumber >= excludedNumber) {
					generatedNumber++;
				}

			} else {
				generatedNumber = generator.generate(max);
			}
			if (isElectedNumber(electedNumbers, generatedNumber)) {
				i--;
				continue;
			} else {
				electedNumbers[i] = generatedNumber;
			}
		}

		return electedNumbers;
	}

	/**
	 * Returns whether target number is elected or not.
	 * 
	 * @param elected numbers
	 * @param target number
	 * @return whether the number is elected
	 */
	private boolean isElectedNumber(int[] electedNumbers, int target) {
		int[] copy = new int[electedNumbers.length];
		for (int i = 0; i < copy.length; i++) {
			copy[i] = electedNumbers[i];
		};

		Arrays.sort(copy);
		int result = Arrays.binarySearch(copy, target);

		return result >= 0;
	}

}
