 /*
 * HosotaniTomokiModel.java
 */
package HomeWork;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.InformationType;
import org.boxed_economy.besp.model.fmfw.RelationType; 

/**
 * Model for Boxed Economy Foundation Model Framework
 *
 * @generated modifiable
 * @version $$Id$$
 */
public class HosotaniTomokiModel implements BESPPlugin {
	
	public static AgentType AGENTTYPE_AiET[Agent;
	public static AgentType AGENTTYPE_Mu[Agent;
	public static BehaviorType BEHAVIORTYPE_AnnouceBehavior;
	public static BehaviorType BEHAVIORTYPE_GambleBehavior;
	public static BehaviorType BEHAVIORTYPE_AnnounceBehavior;
	public static RelationType RELATIONTYPE_HorseRacingRelation;
	
	public static InformationType INFORMATIONTYPE_4thCornerRankingInformation;
	
	public static InformationType INFORMATIONTYPE_ClimaxRankingInformation;
	
	public static InformationType INFORMATIONTYPE_GoalRankingInformation;
	
	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	public static void initializePlugin(BESPContainer container) {
		installTypes(container);
		buildStructure(container);
		setPriority(container);
	}

	/** 
	* This method will be modified automatically by Model Editor
	*
	* @generated
	*/
	private static void installTypes(BESPContainer container) {
		//Get the model container  
		ModelContainer modelContainer = container.getModelContainer();
		
		AGENTTYPE_Mu[Agent=modelContainer.installAgentType("HomeWork.Mu[Agent");
		AGENTTYPE_AiET[Agent=modelContainer.installAgentType("HomeWork.AiET[Agent");
		BEHAVIORTYPE_GambleBehavior=modelContainer.installBehaviorType("HomeWork.GambleBehavior");
		BEHAVIORTYPE_AnnounceBehavior=modelContainer.installBehaviorType("HomeWork.AnnounceBehavior");
		RELATIONTYPE_HorseRacingRelation=modelContainer.installRelationType("HomeWork.HorseRacingRelation");
		INFORMATIONTYPE_4thCornerRankingInformation=modelContainer.installInformationType("HomeWork.4thCornerRankingInformation");
		INFORMATIONTYPE_ClimaxRankingInformation=modelContainer.installInformationType("HomeWork.ClimaxRankingInformation");
		INFORMATIONTYPE_GoalRankingInformation=modelContainer.installInformationType("HomeWork.GoalRankingInformation");
	}

	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	private static void buildStructure(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
	}

	/** 
	* Set priority 
	*
	* @generated modifiable
	*/	
	private static void setPriority(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
		//:TODO set priority
	}
}