/*
 * Created on 2004/06/01
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package homework;

import homework.HomeworkModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.components.stepclock.StepClock;

/**
 * HomeworkWorld
 */
public class HomeworkWorld extends World {

	/*************************************
	 * Class variable and main method for running on the besp
	 *************************************/
	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(HomeworkWorld.class.getName());

	public static void main(String[] args) {
		BESP.main(new String[] { "-model", HomeworkWorld.class.getName()});
	}

	/*************************************
	 * Parameters
	 *************************************/

	//List of agents created from AgentGroup
	private List tamoris = new ArrayList();
	private List girlss = new ArrayList();

	/*************************************
	 * Initialize
	 *************************************/

	/**
	 * Initialize World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#initializeWorld()
	 */
	public void initializeWorld() {
		logger.info("Initialize World.");
		super.initializeWorld();

		//set the clock
		this.setClock(new StepClock());
	}

	/**
	 *  Initialize Agents.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#initializeAgents()
	 */
	public void initializeAgents() {
		logger.info(" Initialize Agents.");
		super.initializeAgents();

		this.createAgents();
		this.addRelations();
		this.initializeByHands();
	}

	/**
	 * this method is not overrided for automaticaly.
	 */
	private void initializeByHands() {
	}

	/**
	 * Create Agents.
	 */
	private void createAgents() {
		logger.info("Create Agents.");

		this.createTamoriAgent();
		this.createGirlsAgent();
	}

	/**
	 * Add Relations
	 */
	private void addRelations() {
		logger.info("Add Relations");

		this.addIitomoFanRelationRelations();
	}

	/*************************************
	 * Subroutines to create agents
	 *************************************/

	/**
	 * Create Tamori Agent
	 */
	private void createTamoriAgent() {
		logger.info("Create Tamori Agent");

		//create agent
		Agent agentTamori =
			super.createAgent(HomeworkModel.AGENTTYPE_TamoriAgent);

		//add behavior(s)
		agentTamori.addBehavior(HomeworkModel.BEHAVIORTYPE_SpeakingBehavior);

		tamoris.add(agentTamori);
	}

	/**
	 * Create Girls Agent
	 */
	private void createGirlsAgent() {
		logger.info("Create Girls Agent");

		//create agent
		Agent agentGirls =
			super.createAgent(HomeworkModel.AGENTTYPE_GirlsAgent);

		//add behavior(s)
		agentGirls.addBehavior(HomeworkModel.BEHAVIORTYPE_RespondingBehavior);

		girlss.add(agentGirls);
	}

	/*************************************
	 * Subroutines to add relations
	 *************************************/

	/**
	 * add IitomoFanRelation relations
	 */
	private void addIitomoFanRelationRelations() {
		logger.info("add IitomoFanRelation relations");

		//set the source and target agents
		List sourceAgents = new ArrayList(tamoris);
		List targetAgents = new ArrayList(girlss);

		//Add Relations
		Agent sourceAgent = (Agent) sourceAgents.get(0);
		Agent targetAgent = (Agent) targetAgents.get(0);

		if (sourceAgent != targetAgent) {
			//add relation from source to target
			sourceAgent.addRelation(
				HomeworkModel.RELATIONTYPE_IitomoFanRelation,
				targetAgent);
		}

	}

	/*************************************
	 * Name and Desctription for World
	 *************************************/

	/**
	 * Returns the description of World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#getDescription()
	 */
	public String getName() {
		return "HomeworkWorld";
	}

	/**
	 * Returns the name of World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#getName()
	 */
	public String getDescription() {
		return "";
	}

	/*************************************
	 * Utility methods for generating random number
	 *************************************/

	/**
	 * Generate random number by double.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private double generateRandomNumberByDouble(
		String generatorName,
		double max,
		double minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		double result = minimum + randomNumber * (max - minimum);

		return result;
	}

	/**
	 * Generate random number by int.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private int generateRandomNumberByInt(
		String generatorName,
		int max,
		int minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		int result = (int) (minimum + randomNumber * (max - minimum));

		return result;
	}

	/**
	 * Generate random number by long.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private long generateRandomNumberByLong(
		String generatorName,
		long max,
		long minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		long result = (long) (minimum + randomNumber * (max - minimum));

		return result;
	}

	/**
	 * generate elected numbers excluded the value at random
	 * 
	 * @param key of random number generator
	 * @param number of elected one
	 * @param max
	 * @param exclude number
	 * @return elected numbers
	 */
	private int[] generateElectedRandomNumbers(
		String generatorName,
		int number,
		int max,
		int excludedNumber) {
		assert(number < max);
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);
		int[] electedNumbers = new int[number];
		Arrays.fill(electedNumbers, -1);

		//generate elected number
		for (int i = 0; i < number; i++) {
			int generatedNumber;
			if (excludedNumber >= 0) {
				generatedNumber = generator.generate(max - 1);
				//exclude the number
				if (generatedNumber >= excludedNumber) {
					generatedNumber++;
				}

			} else {
				generatedNumber = generator.generate(max);
			}
			if (isElectedNumber(electedNumbers, generatedNumber)) {
				i--;
				continue;
			} else {
				electedNumbers[i] = generatedNumber;
			}
		}

		return electedNumbers;
	}

	/**
	 * Returns whether target number is elected or not.
	 * 
	 * @param elected numbers
	 * @param target number
	 * @return whether the number is elected
	 */
	private boolean isElectedNumber(int[] electedNumbers, int target) {
		int[] copy = new int[electedNumbers.length];
		for (int i = 0; i < copy.length; i++) {
			copy[i] = electedNumbers[i];
		};

		Arrays.sort(copy);
		int result = Arrays.binarySearch(copy, target);

		return result >= 0;
	}

}
