/*
 * Created on 2004/06/03
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package clubroom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.components.stepclock.StepClock;

/**
 * ClubroomWorld
 */
public class ClubroomWorld extends World {

	/*************************************
	 * Class variable and main method for running on the besp
	 *************************************/
	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(ClubroomWorld.class.getName());

	public static void main(String[] args) {
		BESP.main(new String[] { "-model", ClubroomWorld.class.getName()});
	}

	/*************************************
	 * Parameters
	 *************************************/

	//List of agents created from AgentGroup
	private List student1s = new ArrayList();
	private List student2s = new ArrayList();
	private List student3s = new ArrayList();
	private List student4s = new ArrayList();

	/*************************************
	 * Initialize
	 *************************************/

	/**
	 * Initialize World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#initializeWorld()
	 */
	public void initializeWorld() {
		logger.info("Initialize World.");
		super.initializeWorld();

		//set the clock
		this.setClock(new StepClock());
	}

	/**
	 *  Initialize Agents.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#initializeAgents()
	 */
	public void initializeAgents() {
		logger.info(" Initialize Agents.");
		super.initializeAgents();

		this.createAgents();
		this.addRelations();
		this.initializeByHands();
	}

	/**
	 * this method is not overrided for automaticaly.
	 */
	private void initializeByHands() {
	}

	/**
	 * Create Agents.
	 */
	private void createAgents() {
		logger.info("Create Agents.");

		this.createStudent1Agent();
		this.createStudent2Agent();
		this.createStudent3Agent();
		this.createStudent4Agent();
	}

	/**
	 * Add Relations
	 */
	private void addRelations() {
		logger.info("Add Relations");

		this.addNewRelationGroupRelations();
	}

	/*************************************
	 * Subroutines to create agents
	 *************************************/

	/**
	 * Create Student1 Agent
	 */
	private void createStudent1Agent() {
		logger.info("Create Student1 Agent");

		//create agent
		Agent agentStudent1 =
			super.createAgent(KonoDaisukeModel.AGENTTYPE_Student1Agent);

		//add behavior(s)
		agentStudent1.addBehavior(
			KonoDaisukeModel.BEHAVIORTYPE_Student1Behavior);

		student1s.add(agentStudent1);
	}

	/**
	 * Create Student2 Agent
	 */
	private void createStudent2Agent() {
		logger.info("Create Student2 Agent");

		//create agent
		Agent agentStudent2 =
			super.createAgent(KonoDaisukeModel.AGENTTYPE_Student2Agent);

		//add behavior(s)
		agentStudent2.addBehavior(
			KonoDaisukeModel.BEHAVIORTYPE_Student2Behavior);

		student2s.add(agentStudent2);
	}

	/**
	 * Create Student3 Agent
	 */
	private void createStudent3Agent() {
		logger.info("Create Student3 Agent");

		//create agent
		Agent agentStudent3 =
			super.createAgent(KonoDaisukeModel.AGENTTYPE_Student3Agent);

		//add behavior(s)
		agentStudent3.addBehavior(
			KonoDaisukeModel.BEHAVIORTYPE_Student3Behavior);

		student3s.add(agentStudent3);
	}

	/**
	 * Create Student4 Agent
	 */
	private void createStudent4Agent() {
		logger.info("Create Student4 Agent");

		//create agent
		Agent agentStudent4 =
			super.createAgent(KonoDaisukeModel.AGENTTYPE_Student4Agent);

		//add behavior(s)
		agentStudent4.addBehavior(
			KonoDaisukeModel.BEHAVIORTYPE_Student4Behavior);

		student4s.add(agentStudent4);
	}

	/*************************************
	 * Subroutines to add relations
	 *************************************/

	/**
	 * add NewRelationGroup relations
	 */
	private void addNewRelationGroupRelations() {
		logger.info("add NewRelationGroup relations");

		//set the source and target agents
		List sourceAgents = new ArrayList(student4s);
		sourceAgents.addAll(student3s);
		sourceAgents.addAll(student2s);
		sourceAgents.addAll(student1s);
		List targetAgents = new ArrayList(student4s);
		targetAgents.addAll(student3s);
		targetAgents.addAll(student2s);
		targetAgents.addAll(student1s);

		//Add Relations
		for (int i = 0; i < sourceAgents.size(); i++) {
			Agent sourceAgent = (Agent) sourceAgents.get(i);

			for (int j = 0; j < targetAgents.size(); j++) {
				Agent targetAgent = (Agent) targetAgents.get(j);

				if (sourceAgent != targetAgent) {
					//add relation from source to target
					sourceAgent.addRelation(
						KonoDaisukeModel.RELATIONTYPE_FriendRelation,
						targetAgent);
					//add reverse relation from target to source
					targetAgent.addRelation(
						KonoDaisukeModel.RELATIONTYPE_FriendRelation,
						sourceAgent);
				}

			}

		}
	}

	/*************************************
	 * Name and Desctription for World
	 *************************************/

	/**
	 * Returns the description of World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#getDescription()
	 */
	public String getName() {
		return "ClubroomWorld";
	}

	/**
	 * Returns the name of World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#getName()
	 */
	public String getDescription() {
		return "";
	}

	/*************************************
	 * Utility methods for generating random number
	 *************************************/

	/**
	 * Generate random number by double.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private double generateRandomNumberByDouble(
		String generatorName,
		double max,
		double minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		double result = minimum + randomNumber * (max - minimum);

		return result;
	}

	/**
	 * Generate random number by int.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private int generateRandomNumberByInt(
		String generatorName,
		int max,
		int minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		int result = (int) (minimum + randomNumber * (max - minimum));

		return result;
	}

	/**
	 * Generate random number by long.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private long generateRandomNumberByLong(
		String generatorName,
		long max,
		long minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		long result = (long) (minimum + randomNumber * (max - minimum));

		return result;
	}

	/**
	 * generate elected numbers excluded the value at random
	 * 
	 * @param key of random number generator
	 * @param number of elected one
	 * @param max
	 * @param exclude number
	 * @return elected numbers
	 */
	private int[] generateElectedRandomNumbers(
		String generatorName,
		int number,
		int max,
		int excludedNumber) {
		assert(number < max);
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);
		int[] electedNumbers = new int[number];
		Arrays.fill(electedNumbers, -1);

		//generate elected number
		for (int i = 0; i < number; i++) {
			int generatedNumber;
			if (excludedNumber >= 0) {
				generatedNumber = generator.generate(max - 1);
				//exclude the number
				if (generatedNumber >= excludedNumber) {
					generatedNumber++;
				}

			} else {
				generatedNumber = generator.generate(max);
			}
			if (isElectedNumber(electedNumbers, generatedNumber)) {
				i--;
				continue;
			} else {
				electedNumbers[i] = generatedNumber;
			}
		}

		return electedNumbers;
	}

	/**
	 * Returns whether target number is elected or not.
	 * 
	 * @param elected numbers
	 * @param target number
	 * @return whether the number is elected
	 */
	private boolean isElectedNumber(int[] electedNumbers, int target) {
		int[] copy = new int[electedNumbers.length];
		for (int i = 0; i < copy.length; i++) {
			copy[i] = electedNumbers[i];
		};

		Arrays.sort(copy);
		int result = Arrays.binarySearch(copy, target);

		return result >= 0;
	}

}
