 /*
 * KoshimaRyosukeModel.java
 */
package kidnapping;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.InformationType;
import org.boxed_economy.besp.model.fmfw.RelationType;

/**
 * Model for Boxed Economy Foundation Model Framework
 *
 * @generated modifiable
 * @version $$Id$$
 */
public class KoshimaRyosukeModel implements BESPPlugin {
	
	public static AgentType AGENTTYPE_Koizumi;
	
	public static AgentType AGENTTYPE_Kim;
	public static BehaviorType BEHAVIORTYPE_KoizumiBehavior;
	public static BehaviorType BEHAVIORTYPE_KimBehavior;
	public static RelationType RELATIONTYPE_InternationalAffairs;
	
	public static InformationType INFORMATIONTYPE_NumberPeople;
	
	public static InformationType INFORMATIONTYPE_KidnappInformation;
	
	public static InformationType INFORMATIONTYPE_AvailableNumberPeople;
	public static GoodsType GOODSTYPE_Victims;
	
	public static GoodsType GOODSTYPE_Rice;
	
	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	public static void initializePlugin(BESPContainer container) {
		installTypes(container);
		buildStructure(container);
		setPriority(container);
	}

	/** 
	* This method will be modified automatically by Model Editor
	*
	* @generated
	*/
	private static void installTypes(BESPContainer container) {
		//Get the model container  
		ModelContainer modelContainer = container.getModelContainer();
		
		AGENTTYPE_Kim=modelContainer.installAgentType("kidnapping.Kim");
		AGENTTYPE_Koizumi=modelContainer.installAgentType("kidnapping.Koizumi");
		BEHAVIORTYPE_KimBehavior=modelContainer.installBehaviorType("kidnapping.KimBehavior");
		BEHAVIORTYPE_KoizumiBehavior=modelContainer.installBehaviorType("kidnapping.KoizumiBehavior");
		RELATIONTYPE_InternationalAffairs=modelContainer.installRelationType("kidnapping.InternationalAffairs");
		INFORMATIONTYPE_NumberPeople=modelContainer.installInformationType("kidnapping.NumberPeople");
		INFORMATIONTYPE_KidnappInformation=modelContainer.installInformationType("kidnapping.KidnappInformation");
		INFORMATIONTYPE_AvailableNumberPeople=modelContainer.installInformationType("kidnapping.AvailableNumberPeople");
		GOODSTYPE_Victims=modelContainer.installGoodsType("kidnapping.Victims");
		GOODSTYPE_Rice=modelContainer.installGoodsType("kidnapping.Rice");
	}

	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	private static void buildStructure(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
	}

	/** 
	* Set priority 
	*
	* @generated modifiable
	*/	
	private static void setPriority(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
		//:TODO set priority
	}
}