 /*
 * BoxKazokuModel.java
 */
package Kazoku;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.InformationType;
import org.boxed_economy.besp.model.fmfw.RelationType; 

/**
 * Model for Boxed Economy Foundation Model Framework
 *
 * @generated modifiable
 * @version $$Id$$
 */
public class BoxKazokuModel implements BESPPlugin {
	
	public static AgentType AGENTTYPE_ChildAgent;
	
	public static AgentType AGENTTYPE_MotherAgent;
	
	
	public static BehaviorType BEHAVIORTYPE_CheckingBehavior;
	public static BehaviorType BEHAVIORTYPE_StudyingBehavior;
	public static RelationType RELATIONTYPE_FamilyRelation;
	
	public static InformationType INFORMATIONTYPE_OkozukaiInformation;
	
	public static InformationType INFORMATIONTYPE_HourInformation;
	public static GoodsType GOODSTYPE_MoneyGoods;
	
	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	public static void initializePlugin(BESPContainer container) {
		installTypes(container);
		buildStructure(container);
		setPriority(container);
	}

	/** 
	* This method will be modified automatically by Model Editor
	*
	* @generated
	*/
	private static void installTypes(BESPContainer container) {
		//Get the model container  
		ModelContainer modelContainer = container.getModelContainer();
		
		AGENTTYPE_MotherAgent=modelContainer.installAgentType("Kazoku.MotherAgent");
		AGENTTYPE_ChildAgent=modelContainer.installAgentType("Kazoku.ChildAgent");
		BEHAVIORTYPE_CheckingBehavior=modelContainer.installBehaviorType("Kazoku.CheckingBehavior");
		BEHAVIORTYPE_StudyingBehavior=modelContainer.installBehaviorType("Kazoku.StudyingBehavior");
		RELATIONTYPE_FamilyRelation=modelContainer.installRelationType("Kazoku.FamilyRelation");
		INFORMATIONTYPE_OkozukaiInformation=modelContainer.installInformationType("Kazoku.OkozukaiInformation");
		INFORMATIONTYPE_HourInformation=modelContainer.installInformationType("Kazoku.HourInformation");
		GOODSTYPE_MoneyGoods=modelContainer.installGoodsType("Kazoku.MoneyGoods");
	}

	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	private static void buildStructure(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
	}

	/** 
	* Set priority 
	*
	* @generated modifiable
	*/	
	private static void setPriority(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
		//:TODO set priority
	}
}