 /*
 * OshidaKeizoModel.java
 */
package work;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.InformationType;
import org.boxed_economy.besp.model.fmfw.RelationType; 

/**
 * Model for Boxed Economy Foundation Model Framework
 *
 * @generated modifiable
 * @version $$Id$$
 */
public class OshidaKeizoModel implements BESPPlugin {
	
	public static AgentType AGENTTYPE_FanAgent;
	
	public static BehaviorType BEHAVIORTYPE_ShoutBehavior;
	public static BehaviorType BEHAVIORTYPE_ReplyBehavior;
	public static AgentType AGENTTYPE_InokiAgent;
	public static RelationType RELATIONTYPE_FavoriteRelation;
	
	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	public static void initializePlugin(BESPContainer container) {
		installTypes(container);
		buildStructure(container);
		setPriority(container);
	}

	/** 
	* This method will be modified automatically by Model Editor
	*
	* @generated
	*/
	private static void installTypes(BESPContainer container) {
		//Get the model container  
		ModelContainer modelContainer = container.getModelContainer();
		
		AGENTTYPE_InokiAgent=modelContainer.installAgentType("work.InokiAgent");
		AGENTTYPE_FanAgent=modelContainer.installAgentType("work.FanAgent");
		BEHAVIORTYPE_ShoutBehavior=modelContainer.installBehaviorType("work.ShoutBehavior");
		BEHAVIORTYPE_ReplyBehavior=modelContainer.installBehaviorType("work.ReplyBehavior");
		RELATIONTYPE_FavoriteRelation=modelContainer.installRelationType("work.FavoriteRelation");
	}

	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	private static void buildStructure(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
	}

	/** 
	* Set priority 
	*
	* @generated modifiable
	*/	
	private static void setPriority(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
		//:TODO set priority
	}
}