 /*
 * ChinoModel.java
 */
package Chino;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.InformationType;
import org.boxed_economy.besp.model.fmfw.RelationType; 

/**
 * Model for Boxed Economy Foundation Model Framework
 *
 * @generated modifiable
 * @version $$Id$$
 */
public class ChinoModel implements BESPPlugin {
	
	public static AgentType AGENTTYPE_BoyAgent;
	
	public static BehaviorType BEHAVIORTYPE_ListeningBehavior;
	public static BehaviorType BEHAVIORTYPE_TalkingBehavior;
	public static AgentType AGENTTYPE_GirlAgent;
	public static RelationType RELATIONTYPE_CoupleRelation;
	
	public static InformationType INFORMATIONTYPE_PriceInformation;
	public static InformationType INFORMATIONTYPE_OrderInformation;
	public static GoodsType GOODSTYPE_SandwichesGoods;
	
	public static GoodsType GOODSTYPE_NewGoods;
	public static GoodsType GOODSTYPE_MoneyGoods;
	
	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	public static void initializePlugin(BESPContainer container) {
		installTypes(container);
		buildStructure(container);
		setPriority(container);
	}

	/** 
	* This method will be modified automatically by Model Editor
	*
	* @generated
	*/
	private static void installTypes(BESPContainer container) {
		//Get the model container  
		ModelContainer modelContainer = container.getModelContainer();
		
		AGENTTYPE_GirlAgent=modelContainer.installAgentType("Chino.GirlAgent");
		AGENTTYPE_BoyAgent=modelContainer.installAgentType("Chino.BoyAgent");
		BEHAVIORTYPE_TalkingBehavior=modelContainer.installBehaviorType("Chino.TalkingBehavior");
		BEHAVIORTYPE_ListeningBehavior=modelContainer.installBehaviorType("Chino.ListeningBehavior");
		RELATIONTYPE_CoupleRelation=modelContainer.installRelationType("Chino.CoupleRelation");
		INFORMATIONTYPE_PriceInformation=modelContainer.installInformationType("Chino.PriceInformation");
		INFORMATIONTYPE_OrderInformation=modelContainer.installInformationType("Chino.OrderInformation");
		GOODSTYPE_SandwichesGoods=modelContainer.installGoodsType("Chino.SandwichesGoods");
		GOODSTYPE_MoneyGoods=modelContainer.installGoodsType("Chino.MoneyGoods");
	}

	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	private static void buildStructure(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
	}

	/** 
	* Set priority 
	*
	* @generated modifiable
	*/	
	private static void setPriority(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
		//:TODO set priority
	}
}