 /*
 * RyojiTakahashiModel.java
 */
package baseball;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.InformationType;
import org.boxed_economy.besp.model.fmfw.RelationType; 

/**
 * Model for Boxed Economy Foundation Model Framework
 *
 * @generated modifiable
 * @version $$Id$$
 */
public class RyojiTakahashiModel implements BESPPlugin {
	
	public static AgentType AGENTTYPE_PitcherAgent;
	public static BehaviorType BEHAVIORTYPE_PitcherBehavior;
	public static BehaviorType BEHAVIORTYPE_SignBehavior;
	public static AgentType AGENTTYPE_CatcherAgent;
	
	public static RelationType RELATIONTYPE_PitchingRelation;
	
	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	public static void initializePlugin(BESPContainer container) {
		installTypes(container);
		buildStructure(container);
		setPriority(container);
	}

	/** 
	* This method will be modified automatically by Model Editor
	*
	* @generated
	*/
	private static void installTypes(BESPContainer container) {
		//Get the model container  
		ModelContainer modelContainer = container.getModelContainer();
		
		AGENTTYPE_CatcherAgent=modelContainer.installAgentType("baseball.CatcherAgent");
		AGENTTYPE_PitcherAgent=modelContainer.installAgentType("baseball.PitcherAgent");
		BEHAVIORTYPE_PitcherBehavior=modelContainer.installBehaviorType("baseball.PitcherBehavior");
		BEHAVIORTYPE_SignBehavior=modelContainer.installBehaviorType("baseball.SignBehavior");
		RELATIONTYPE_PitchingRelation=modelContainer.installRelationType("baseball.PitchingRelation");
	}

	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	private static void buildStructure(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
	}

	/** 
	* Set priority 
	*
	* @generated modifiable
	*/	
	private static void setPriority(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
		//:TODO set priority
	}
}