 /*
 * TakatsuRyoModel.java
 */
package casablanca;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.InformationType;
import org.boxed_economy.besp.model.fmfw.RelationType; 

/**
 * Model for Boxed Economy Foundation Model Framework
 *
 * @generated modifiable
 * @version $$Id$$
 */
public class TakatsuRyoModel implements BESPPlugin {
	
	public static AgentType AGENTTYPE_BarOwner;
	
	public static AgentType AGENTTYPE_Ellza;
	public static BehaviorType BEHAVIORTYPE_AnsweringBehavior;
	public static BehaviorType BEHAVIORTYPE_AskingQuestionBehavior;
	public static RelationType RELATIONTYPE_ExloverRelation;
	
	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	public static void initializePlugin(BESPContainer container) {
		installTypes(container);
		buildStructure(container);
		setPriority(container);
	}

	/** 
	* This method will be modified automatically by Model Editor
	*
	* @generated
	*/
	private static void installTypes(BESPContainer container) {
		//Get the model container  
		ModelContainer modelContainer = container.getModelContainer();
		
		AGENTTYPE_Ellza=modelContainer.installAgentType("casablanca.Ellza");
		AGENTTYPE_BarOwner=modelContainer.installAgentType("casablanca.BarOwner");
		BEHAVIORTYPE_AnsweringBehavior=modelContainer.installBehaviorType("casablanca.AnsweringBehavior");
		BEHAVIORTYPE_AskingQuestionBehavior=modelContainer.installBehaviorType("casablanca.AskingQuestionBehavior");
		RELATIONTYPE_ExloverRelation=modelContainer.installRelationType("casablanca.ExloverRelation");
	}

	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	private static void buildStructure(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
	}

	/** 
	* Set priority 
	*
	* @generated modifiable
	*/	
	private static void setPriority(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
		//:TODO set priority
	}
}