 /*
 * RussiaModel.java
 */
package russianTalk;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.InformationType;
import org.boxed_economy.besp.model.fmfw.RelationType; 

/**
 * Model for Boxed Economy Foundation Model Framework
 *
 * @generated modifiable
 * @version $$Id$$
 */
public class RussiaModel implements BESPPlugin {
	
	public static AgentType AGENTTYPE_NewAgent;
	public static AgentType AGENTTYPE_speakerA;
	public static AgentType AGENTTYPE_speakerB;
	public static BehaviorType BEHAVIORTYPE_speakBehavior;
	public static BehaviorType BEHAVIORTYPE_replyBehavior;
	public static RelationType RELATIONTYPE_talkingRelation;
	public static RelationType RELATIONTYPE_replyBehavior;
	
	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	public static void initializePlugin(BESPContainer container) {
		installTypes(container);
		buildStructure(container);
		setPriority(container);
	}

	/** 
	* This method will be modified automatically by Model Editor
	*
	* @generated
	*/
	private static void installTypes(BESPContainer container) {
		//Get the model container  
		ModelContainer modelContainer = container.getModelContainer();
		
		AGENTTYPE_NewAgent=modelContainer.installAgentType("russianTalk.NewAgent");
		AGENTTYPE_speakerA=modelContainer.installAgentType("russianTalk.speakerA");
		AGENTTYPE_speakerB=modelContainer.installAgentType("russianTalk.speakerB");
		BEHAVIORTYPE_speakBehavior=modelContainer.installBehaviorType("russianTalk.speakBehavior");
		BEHAVIORTYPE_replyBehavior=modelContainer.installBehaviorType("russianTalk.replyBehavior");
		RELATIONTYPE_talkingRelation=modelContainer.installRelationType("russianTalk.talkingRelation");
	}

	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	private static void buildStructure(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
	}

	/** 
	* Set priority 
	*
	* @generated modifiable
	*/	
	private static void setPriority(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
		//:TODO set priority
	}
}