/*
 * Created on 2004/06/01
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package Uwaki;

import Uwaki.UwakiGenbaModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Goods;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.components.stepclock.StepClock;

/**
 * UwakiWorld
 */
public class UwakiWorld extends World {

	/*************************************
	 * Class variable and main method for running on the besp
	 *************************************/
	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(UwakiWorld.class.getName());

	public static void main(String[] args) {
		BESP.main(new String[] { "-model", UwakiWorld.class.getName()});
	}

	/*************************************
	 * Parameters
	 *************************************/

	//List of agents created from AgentGroup
	private List boys = new ArrayList();
	private List girls = new ArrayList();

	/*************************************
	 * Initialize
	 *************************************/

	/**
	 * Initialize World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#initializeWorld()
	 */
	public void initializeWorld() {
		logger.info("Initialize World.");
		super.initializeWorld();

		//set the clock
		this.setClock(new StepClock());
	}

	/**
	 *  Initialize Agents.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#initializeAgents()
	 */
	public void initializeAgents() {
		logger.info(" Initialize Agents.");
		super.initializeAgents();

		this.createAgents();
		this.addRelations();
		this.initializeByHands();
	}

	/**
	 * this method is not overrided for automaticaly.
	 */
	private void initializeByHands() {
	}

	/**
	 * Create Agents.
	 */
	private void createAgents() {
		logger.info("Create Agents.");

		this.createBoyAgent();
		this.createGirlAgent();
	}

	/**
	 * Add Relations
	 */
	private void addRelations() {
		logger.info("Add Relations");

		this.addCoupleRelations();
	}

	/*************************************
	 * Subroutines to create agents
	 *************************************/

	/**
	 * Create Boy Agent
	 */
	private void createBoyAgent() {
		logger.info("Create Boy Agent");

		//create agent
		Agent agentBoy = super.createAgent(UwakiGenbaModel.AGENTTYPE_BoyAgent);

		//add behavior(s)
		agentBoy.addBehavior(UwakiGenbaModel.BEHAVIORTYPE_ExcuseBehavior);

		//add goods
		Goods goodsGOODSTYPE_PhoneGoods =
			super.createGoods(UwakiGenbaModel.GOODSTYPE_PhoneGoods, 10);
		agentBoy.addGoods(goodsGOODSTYPE_PhoneGoods);

		boys.add(agentBoy);
	}

	/**
	 * Create Girl Agent
	 */
	private void createGirlAgent() {
		logger.info("Create Girl Agent");

		//create agent
		Agent agentGirl =
			super.createAgent(UwakiGenbaModel.AGENTTYPE_GirlAgent);

		//add behavior(s)
		agentGirl.addBehavior(UwakiGenbaModel.BEHAVIORTYPE_DemandBehavior);

		//add goods
		Goods goodsGOODSTYPE_KnifeGoods =
			super.createGoods(UwakiGenbaModel.GOODSTYPE_KnifeGoods, 10);
		agentGirl.addGoods(goodsGOODSTYPE_KnifeGoods);

		girls.add(agentGirl);
	}

	/*************************************
	 * Subroutines to add relations
	 *************************************/

	/**
	 * add Couple relations
	 */
	private void addCoupleRelations() {
		logger.info("add Couple relations");

		//set the source and target agents
		List sourceAgents = new ArrayList(girls);
		List targetAgents = new ArrayList(boys);

		//Add Relations
		Agent sourceAgent = (Agent) sourceAgents.get(0);
		Agent targetAgent = (Agent) targetAgents.get(0);

		if (sourceAgent != targetAgent) {
			//add relation from source to target
			sourceAgent.addRelation(
				UwakiGenbaModel.RELATIONTYPE_CoupleRelation,
				targetAgent);
			//add reverse relation from target to source
			targetAgent.addRelation(
				UwakiGenbaModel.RELATIONTYPE_CoupleRelation,
				sourceAgent);
		}

	}

	/*************************************
	 * Name and Desctription for World
	 *************************************/

	/**
	 * Returns the description of World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#getDescription()
	 */
	public String getName() {
		return "UwakiWorld";
	}

	/**
	 * Returns the name of World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#getName()
	 */
	public String getDescription() {
		return "";
	}

	/*************************************
	 * Utility methods for generating random number
	 *************************************/

	/**
	 * Generate random number by double.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private double generateRandomNumberByDouble(
		String generatorName,
		double max,
		double minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		double result = minimum + randomNumber * (max - minimum);

		return result;
	}

	/**
	 * Generate random number by int.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private int generateRandomNumberByInt(
		String generatorName,
		int max,
		int minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		int result = (int) (minimum + randomNumber * (max - minimum));

		return result;
	}

	/**
	 * Generate random number by long.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private long generateRandomNumberByLong(
		String generatorName,
		long max,
		long minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		long result = (long) (minimum + randomNumber * (max - minimum));

		return result;
	}

	/**
	 * generate elected numbers excluded the value at random
	 * 
	 * @param key of random number generator
	 * @param number of elected one
	 * @param max
	 * @param exclude number
	 * @return elected numbers
	 */
	private int[] generateElectedRandomNumbers(
		String generatorName,
		int number,
		int max,
		int excludedNumber) {
		assert(number < max);
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);
		int[] electedNumbers = new int[number];
		Arrays.fill(electedNumbers, -1);

		//generate elected number
		for (int i = 0; i < number; i++) {
			int generatedNumber;
			if (excludedNumber >= 0) {
				generatedNumber = generator.generate(max - 1);
				//exclude the number
				if (generatedNumber >= excludedNumber) {
					generatedNumber++;
				}

			} else {
				generatedNumber = generator.generate(max);
			}
			if (isElectedNumber(electedNumbers, generatedNumber)) {
				i--;
				continue;
			} else {
				electedNumbers[i] = generatedNumber;
			}
		}

		return electedNumbers;
	}

	/**
	 * Returns whether target number is elected or not.
	 * 
	 * @param elected numbers
	 * @param target number
	 * @return whether the number is elected
	 */
	private boolean isElectedNumber(int[] electedNumbers, int target) {
		int[] copy = new int[electedNumbers.length];
		for (int i = 0; i < copy.length; i++) {
			copy[i] = electedNumbers[i];
		};

		Arrays.sort(copy);
		int result = Arrays.binarySearch(copy, target);

		return result >= 0;
	}

}
