 /*
 * EvolvingNetworkModel.java
 */
package org.boxed_economy.evolvingnetwork;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.RelationType;

/**
 * Model for Boxed Economy Foundation Model Framework
 *
 * @generated modifiable
 * @version $$Id$$
 */
public class EvolvingNetworkModel implements BESPPlugin {
	
	public static AgentType AGENTTYPE_Organizer;
	public static AgentType AGENTTYPE_Node;
	public static BehaviorType BEHAVIORTYPE_PreferentialAttachBehavior;
	public static BehaviorType BEHAVIORTYPE_RandomAttachBehavior;
	public static RelationType RELATIONTYPE_Subject;
	public static RelationType RELATIONTYPE_Link;
	
	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	public static void initializePlugin(BESPContainer container) {
		installTypes(container);
		buildStructure(container);
		setPriority(container);
	}

	/** 
	* This method will be modified automatically by Model Editor
	*
	* @generated
	*/
	private static void installTypes(BESPContainer container) {
		//Get the model container  
		ModelContainer modelContainer = container.getModelContainer();
		
		AGENTTYPE_Node=modelContainer.installAgentType("org.boxed_economy.evolvingnetwork.Node");
		AGENTTYPE_Organizer=modelContainer.installAgentType("org.boxed_economy.evolvingnetwork.Organizer");
		BEHAVIORTYPE_PreferentialAttachBehavior=modelContainer.installBehaviorType("org.boxed_economy.evolvingnetwork.PreferentialAttachBehavior");
		BEHAVIORTYPE_RandomAttachBehavior=modelContainer.installBehaviorType("org.boxed_economy.evolvingnetwork.RandomAttachBehavior");
		RELATIONTYPE_Link=modelContainer.installRelationType("org.boxed_economy.evolvingnetwork.Link");
	}

	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	private static void buildStructure(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
	}

	/** 
	* Set priority 
	*
	* @generated modifiable
	*/	
	private static void setPriority(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
		//:TODO set priority
	}
}