/*
 * FormatCompetitionModel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.model;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.InformationType;
import org.boxed_economy.besp.model.fmfw.RelationType;

/**
 * @author iba
 * @version $Id: FormatCompetitionModel.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public class FormatCompetitionModel implements BESPPlugin {

	public static AgentType AGENTTYPE_ShopAgent;
	public static AgentType AGENTTYPE_SurveyCompanyAgent;
	public static AgentType AGENTTYPE_ConsumerAgent;
	public static AgentType AGENTTYPE_DiffiusionControlFunctionAgent;
	public static BehaviorType BEHAVIORTYPE_RecognizeVCRNeedsBehavior;
	public static BehaviorType BEHAVIORTYPE_PurchaseVCRBehavior;
	public static BehaviorType BEHAVIORTYPE_UseVCRBehavior;
	public static BehaviorType BEHAVIORTYPE_ReplyFormatBehavior;
	public static BehaviorType BEHAVIORTYPE_SellVCRBehavior;
	public static BehaviorType BEHAVIORTYPE_ReplyMarketShareBehavior;
	public static BehaviorType BEHAVIORTYPE_SurveyBehavior;
	public static BehaviorType BEHAVIORTYPE_PermitVCRNeedsBehavior;
	public static RelationType RELATIONTYPE_InformationSupplierRelation;
	public static RelationType RELATIONTYPE_SellerRelation;
	public static RelationType RELATIONTYPE_SurveyTargetRelation;
	public static RelationType RELATIONTYPE_FriendRelation;
	public static RelationType RELATIONTYPE_DiffusionControllerRelation;
	public static InformationType INFORMATIONTYPE_NeedsPermissionInformation;
	public static InformationType INFORMATIONTYPE_FormatAnswerListInformation;
	public static InformationType INFORMATIONTYPE_FormatAnswerInformation;
	public static InformationType INFORMATIONTYPE_NeedsPermissionRequestInformation;
	public static InformationType INFORMATIONTYPE_FormatQuestionInformation;
	public static InformationType INFORMATIONTYPE_OrderInformation;
	public static InformationType INFORMATIONTYPE_FormatAnswerListRequestInformation;
	public static InformationType INFORMATIONTYPE_DurabilityInformation;
	public static InformationType INFORMATIONTYPE_PreferenceInformation;
	public static GoodsType GOODSTYPE_VCRGoods;
	public static GoodsType GOODSTYPE_Format1Goods;
	public static GoodsType GOODSTYPE_Format2Goods;

	//Priority
	public static int PRIORITY_DiffusionControlFunction =
		ModelContainer.PRIORITY_DEFAULT + 300;
	public static int PRIORITY_SurveyCompany =
		ModelContainer.PRIORITY_DEFAULT + 200;
	public static int PRIORITY_Consumer = ModelContainer.PRIORITY_DEFAULT + 100;
	public static int PRIORITY_Shop = ModelContainer.PRIORITY_DEFAULT;

	/**
	* KiV~[Vɑ݂Type`܂
	*  >  > ̔X ƂvCIeBtsĂ܂
	*/
	public static void initializePlugin(BESPContainer container) {
		installTypes(container);
		buildStructure(container);
		setPriority(container);
	}

	/** 
	* This method will be modified automatically by Model Editor
	*
	* @generated
	*/
	private static void installTypes(BESPContainer container) {
		//Get the model container  
		ModelContainer modelContainer = container.getModelContainer();
		
		AGENTTYPE_ShopAgent=modelContainer.installAgentType("org.boxed_economy.formatcompetition.model.ShopAgent");
		AGENTTYPE_DiffiusionControlFunctionAgent=modelContainer.installAgentType("org.boxed_economy.formatcompetition.model.DiffiusionControlFunctionAgent");
		AGENTTYPE_SurveyCompanyAgent=modelContainer.installAgentType("org.boxed_economy.formatcompetition.model.SurveyCompanyAgent");
		AGENTTYPE_ConsumerAgent=modelContainer.installAgentType("org.boxed_economy.formatcompetition.model.ConsumerAgent");
		BEHAVIORTYPE_RecognizeVCRNeedsBehavior=modelContainer.installBehaviorType("org.boxed_economy.formatcompetition.model.behavior.RecognizeVCRNeedsBehavior");
		BEHAVIORTYPE_PurchaseVCRBehavior=modelContainer.installBehaviorType("org.boxed_economy.formatcompetition.model.behavior.PurchaseVCRBehavior");
		BEHAVIORTYPE_UseVCRBehavior=modelContainer.installBehaviorType("org.boxed_economy.formatcompetition.model.behavior.UseVCRBehavior");
		BEHAVIORTYPE_ReplyFormatBehavior=modelContainer.installBehaviorType("org.boxed_economy.formatcompetition.model.behavior.ReplyFormatBehavior");
		BEHAVIORTYPE_SellVCRBehavior=modelContainer.installBehaviorType("org.boxed_economy.formatcompetition.model.behavior.SellVCRBehavior");
		BEHAVIORTYPE_ReplyMarketShareBehavior=modelContainer.installBehaviorType("org.boxed_economy.formatcompetition.model.behavior.ReplyMarketShareBehavior");
		BEHAVIORTYPE_SurveyBehavior=modelContainer.installBehaviorType("org.boxed_economy.formatcompetition.model.behavior.SurveyBehavior");
		BEHAVIORTYPE_PermitVCRNeedsBehavior=modelContainer.installBehaviorType("org.boxed_economy.formatcompetition.model.behavior.PermitVCRNeedsBehavior");
		RELATIONTYPE_InformationSupplierRelation=modelContainer.installRelationType("org.boxed_economy.formatcompetition.model.InformationSupplierRelation");
		RELATIONTYPE_SellerRelation=modelContainer.installRelationType("org.boxed_economy.formatcompetition.model.SellerRelation");
		RELATIONTYPE_DiffusionControllerRelation=modelContainer.installRelationType("org.boxed_economy.formatcompetition.model.DiffusionControllerRelation");
		RELATIONTYPE_SurveyTargetRelation=modelContainer.installRelationType("org.boxed_economy.formatcompetition.model.SurveyTargetRelation");
		RELATIONTYPE_FriendRelation=modelContainer.installRelationType("org.boxed_economy.formatcompetition.model.FriendRelation");
		INFORMATIONTYPE_NeedsPermissionInformation=modelContainer.installInformationType("org.boxed_economy.formatcompetition.model.information.NeedsPermissionInformation");
		INFORMATIONTYPE_FormatAnswerInformation=modelContainer.installInformationType("org.boxed_economy.formatcompetition.model.information.FormatAnswerInformation");
		INFORMATIONTYPE_FormatAnswerListInformation=modelContainer.installInformationType("org.boxed_economy.formatcompetition.model.information.FormatAnswerListInformation");
		INFORMATIONTYPE_NeedsPermissionRequestInformation=modelContainer.installInformationType("org.boxed_economy.formatcompetition.model.information.NeedsPermissionRequestInformation");
		INFORMATIONTYPE_FormatQuestionInformation=modelContainer.installInformationType("org.boxed_economy.formatcompetition.model.information.FormatQuestionInformation");
		INFORMATIONTYPE_OrderInformation=modelContainer.installInformationType("org.boxed_economy.formatcompetition.model.information.OrderInformation");
		INFORMATIONTYPE_FormatAnswerListRequestInformation=modelContainer.installInformationType("org.boxed_economy.formatcompetition.model.information.FormatAnswerListRequestInformation");
		INFORMATIONTYPE_DurabilityInformation=modelContainer.installInformationType("org.boxed_economy.formatcompetition.model.information.DurabilityInformation");
		INFORMATIONTYPE_PreferenceInformation=modelContainer.installInformationType("org.boxed_economy.formatcompetition.model.information.PreferenceInformation");
		GOODSTYPE_Format1Goods=modelContainer.installGoodsType("org.boxed_economy.formatcompetition.model.Format1Goods");
		GOODSTYPE_Format2Goods=modelContainer.installGoodsType("org.boxed_economy.formatcompetition.model.Format2Goods");
		GOODSTYPE_VCRGoods=modelContainer.installGoodsType("org.boxed_economy.formatcompetition.model.VCRGoods");
	}

	/** 
	* This method will be modified automatically by Model Editor 
	*
	* @generated
	*/
	private static void buildStructure(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();
		
		GOODSTYPE_VCRGoods.addChild(GOODSTYPE_Format1Goods);
		GOODSTYPE_VCRGoods.addChild(GOODSTYPE_Format2Goods);
	}

	/** 
	* Set priority 
	*
	* @generated modifiable
	*/
	private static void setPriority(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();

		modelContainer.setPriority(
			AGENTTYPE_DiffiusionControlFunctionAgent,
			PRIORITY_DiffusionControlFunction);
		modelContainer.setPriority(
			AGENTTYPE_SurveyCompanyAgent,
			PRIORITY_SurveyCompany);
		modelContainer.setPriority(AGENTTYPE_ConsumerAgent, PRIORITY_Consumer);
		modelContainer.setPriority(AGENTTYPE_ShopAgent, PRIORITY_Shop);
	}
}
