package org.boxed_economy.formatcompetition.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.model.fmfw.informations.DoubleInformation;
import org.boxed_economy.components.stepclock.StepClock;

/**
 * FormatCompetitionWorld
 */
public class FormatCompetitionWorld extends World {

	/*************************************
	 * Class variable and main method for running on the besp
	 *************************************/
	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(FormatCompetitionWorld.class.getName());

	public static void main(String[] args) {
		BESP.main(
			new String[] { "-model", FormatCompetitionWorld.class.getName()});
	}

	/*************************************
	 * Parameters
	 *************************************/
	private int r = 10;
	private double l = 0.0;
	private double g = 0.0;
	private double p = 1.0;
	private int consumerNumber = 200;
	private int initialDurability = 100;

	//List of agents created from AgentGroup
	private List surveyCompanys = new ArrayList();
	private List shops = new ArrayList();
	private List consumers = new ArrayList();
	private List diffusionControlFunctions = new ArrayList();

	/*************************************
	 * Initialize
	 *************************************/

	/**
	 * Initialize World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#initializeWorld()
	 */
	public void initializeWorld() {
		logger.info("Initialize World.");
		super.initializeWorld();

		//set the clock
		this.setClock(new StepClock());
	}

	/**
	 *  Initialize Agents.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#initializeAgents()
	 */
	public void initializeAgents() {
		logger.info(" Initialize Agents.");
		super.initializeAgents();

		this.createAgents();
		this.addRelations();
		this.initializeByHands();
	}

	/**
	 * this method is not overrided for automaticaly.
	 */
	private void initializeByHands() {
	}

	/**
	 * Create Agents.
	 */
	private void createAgents() {
		logger.info("Create Agents.");

		this.createSurveyCompanyAgent();
		this.createShopAgent();
		this.createConsumerAgents();
		this.createDiffusionControlFunctionAgent();
	}

	/**
	 * Add Relations
	 */
	private void addRelations() {
		logger.info("Add Relations");

		this.addSurveyTargetRelations();
		this.addInformationSupplierRelations();
		this.addSellerRelations();
		this.addDiffusionControllerRelations();
		this.addFriendRelations();
	}

	/*************************************
	 * Subroutines to create agents
	 *************************************/

	/**
	 * Create Consumer Agents
	 */
	private void createConsumerAgents() {
		logger.info("Create Consumer Agents");

		for (int i = 0; i < consumerNumber; i++) {
			this.createConsumerAgent();
		}
	}

	/**
	 * Create SurveyCompany Agent
	 */
	private void createSurveyCompanyAgent() {
		logger.info("Create SurveyCompany Agent");

		//create agent
		Agent agentSurveyCompany =
			super.createAgent(
				FormatCompetitionModel.AGENTTYPE_SurveyCompanyAgent);

		//add behavior(s)
		agentSurveyCompany.addBehavior(
			FormatCompetitionModel.BEHAVIORTYPE_SurveyBehavior);

		surveyCompanys.add(agentSurveyCompany);
	}

	/**
	 * Create Shop Agent
	 */
	private void createShopAgent() {
		logger.info("Create Shop Agent");

		//create agent
		Agent agentShop =
			super.createAgent(FormatCompetitionModel.AGENTTYPE_ShopAgent);

		//add behavior(s)
		agentShop.addBehavior(
			FormatCompetitionModel.BEHAVIORTYPE_SellVCRBehavior);

		shops.add(agentShop);
	}

	/**
	 * Create Consumer Agent
	 */
	private void createConsumerAgent() {
		logger.info("Create Consumer Agent");

		//create agent
		Agent agentConsumer =
			super.createAgent(FormatCompetitionModel.AGENTTYPE_ConsumerAgent);

		//add behavior(s)
		agentConsumer.addBehavior(
			FormatCompetitionModel.BEHAVIORTYPE_RecognizeVCRNeedsBehavior);
		agentConsumer.addBehavior(
			FormatCompetitionModel.BEHAVIORTYPE_ReplyFormatBehavior);

		//put information
		agentConsumer.putInformation(
			FormatCompetitionModel.INFORMATIONTYPE_PreferenceInformation,
			this.createDoubleInformationForAgentConsumer(agentConsumer));

		consumers.add(agentConsumer);
	}

	/**
	 * Create DiffusionControlFunction Agent
	 */
	private void createDiffusionControlFunctionAgent() {
		logger.info("Create DiffusionControlFunction Agent");

		//create agent
		Agent agentDiffusionControlFunction =
			super.createAgent(
				FormatCompetitionModel
					.AGENTTYPE_DiffiusionControlFunctionAgent);

		//add behavior(s)
		agentDiffusionControlFunction.addBehavior(
			FormatCompetitionModel.BEHAVIORTYPE_PermitVCRNeedsBehavior);

		diffusionControlFunctions.add(agentDiffusionControlFunction);
	}

	/*************************************
	 * Subroutines to add relations
	 *************************************/

	/**
	 * add SurveyTarget relations
	 */
	private void addSurveyTargetRelations() {
		logger.info("add SurveyTarget relations");

		//set the source and target agents
		List sourceAgents = new ArrayList(surveyCompanys);
		List targetAgents = new ArrayList(consumers);

		Agent sourceAgent = (Agent) sourceAgents.get(0);

		for (int i = 0; i < targetAgents.size(); i++) {
			Agent targetAgent = (Agent) targetAgents.get(i);

			if (sourceAgent != targetAgent) {
				//add relation from source to target
				sourceAgent.addRelation(
					FormatCompetitionModel.RELATIONTYPE_SurveyTargetRelation,
					targetAgent);
			}

		}

	}

	/**
	 * add InformationSupplier relations
	 */
	private void addInformationSupplierRelations() {
		logger.info("add InformationSupplier relations");

		//set the source and target agents
		List sourceAgents = new ArrayList(consumers);
		List targetAgents = new ArrayList(surveyCompanys);

		Agent targetAgent = (Agent) targetAgents.get(0);

		//Add Relations
		for (int i = 0; i < sourceAgents.size(); i++) {
			Agent sourceAgent = (Agent) sourceAgents.get(i);

			if (sourceAgent != targetAgent) {
				//add relation from source to target
				sourceAgent.addRelation(
					FormatCompetitionModel
						.RELATIONTYPE_InformationSupplierRelation,
					targetAgent);
			}

		}

	}

	/**
	 * add Seller relations
	 */
	private void addSellerRelations() {
		logger.info("add Seller relations");

		//set the source and target agents
		List sourceAgents = new ArrayList(consumers);
		List targetAgents = new ArrayList(shops);

		Agent targetAgent = (Agent) targetAgents.get(0);

		//Add Relations
		for (int i = 0; i < sourceAgents.size(); i++) {
			Agent sourceAgent = (Agent) sourceAgents.get(i);

			if (sourceAgent != targetAgent) {
				//add relation from source to target
				sourceAgent.addRelation(
					FormatCompetitionModel.RELATIONTYPE_SellerRelation,
					targetAgent);
			}

		}

	}

	/**
	 * add DiffusionController relations
	 */
	private void addDiffusionControllerRelations() {
		logger.info("add DiffusionController relations");

		//set the source and target agents
		List sourceAgents = new ArrayList(consumers);
		List targetAgents = new ArrayList(diffusionControlFunctions);

		Agent targetAgent = (Agent) targetAgents.get(0);

		//Add Relations
		for (int i = 0; i < sourceAgents.size(); i++) {
			Agent sourceAgent = (Agent) sourceAgents.get(i);

			if (sourceAgent != targetAgent) {
				//add relation from source to target
				sourceAgent.addRelation(
					FormatCompetitionModel
						.RELATIONTYPE_DiffusionControllerRelation,
					targetAgent);
			}

		}

	}

	/**
	 * add Friend relations
	 */
	private void addFriendRelations() {
		logger.info("add Friend relations");

		//set the source and target agents
		List agents = new ArrayList(consumers);

		//Add Relations
		for (int i = 0; i < agents.size(); i++) {
			for (int j = i - r; j <= i + r; j++) {
				int source = i;
				int target = j;

				if (target < 0) {
					target = agents.size() + target;
				} else if (target >= agents.size()) {
					target = target - agents.size();
				}

				if (target >= 0
					&& target < agents.size()
					&& source != target) {
					Agent sourceAgent = (Agent) agents.get(source);
					Agent targetAgent = (Agent) agents.get(target);
					//add relation from source to target
					sourceAgent.addRelation(
						FormatCompetitionModel.RELATIONTYPE_FriendRelation,
						targetAgent);
				}

			}

		}
	}

	/*************************************
	 * Name and Desctription for World
	 *************************************/

	/**
	 * Returns the description of World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#getDescription()
	 */
	public String getName() {
		return "FormatCompetitionWorld";
	}

	/**
	 * Returns the name of World.
	 * 
	 * @see org.boxed_economy.besp.model.fmfw.World#getName()
	 */
	public String getDescription() {
		return "KiV~[V̐Eł";
	}

	/*************************************
	 * Factory method(s) for Information
	 *************************************/

	/**
	 * create DoubleInformationForAgentConsumer
	 */
	private DoubleInformation createDoubleInformationForAgentConsumer(Agent agent) {
		double random = this.getRandomNumberGenerator().generate();
		return new DoubleInformation(random);
	}

	/*************************************
	 * Utility methods for generating random number
	 *************************************/

	/**
	 * Generate random number by double.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private double generateRandomNumberByDouble(
		String generatorName,
		double max,
		double minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		double result = minimum + randomNumber * (max - minimum);

		return result;
	}

	/**
	 * Generate random number by int.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private int generateRandomNumberByInt(
		String generatorName,
		int max,
		int minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		int result = (int) (minimum + randomNumber * (max - minimum));

		return result;
	}

	/**
	 * Generate random number by long.
	 * 
	 * @param key of random number generator
	 * @param minimum
	 * @param max
	 * @return random number
	 */
	private long generateRandomNumberByLong(
		String generatorName,
		long max,
		long minimum) {
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);

		//generate random number.
		double randomNumber = generator.generate();
		long result = (long) (minimum + randomNumber * (max - minimum));

		return result;
	}

	/**
	 * generate elected numbers excluded the value at random
	 * 
	 * @param key of random number generator
	 * @param number of elected one
	 * @param max
	 * @param exclude number
	 * @return elected numbers
	 */
	private int[] generateElectedRandomNumbers(
		String generatorName,
		int number,
		int max,
		int excludedNumber) {
		assert(number < max);
		RandomNumberGenerator generator =
			super.getRandomNumberGenerator(generatorName);
		int[] electedNumbers = new int[number];
		Arrays.fill(electedNumbers, -1);

		//generate elected number
		for (int i = 0; i < number; i++) {
			int generatedNumber;
			if (excludedNumber >= 0) {
				generatedNumber = generator.generate(max - 1);
				//exclude the number
				if (generatedNumber >= excludedNumber) {
					generatedNumber++;
				}

			} else {
				generatedNumber = generator.generate(max);
			}
			if (isElectedNumber(electedNumbers, generatedNumber)) {
				i--;
				continue;
			} else {
				electedNumbers[i] = generatedNumber;
			}
		}

		return electedNumbers;
	}

	/**
	 * Returns whether target number is elected or not.
	 * 
	 * @param elected numbers
	 * @param target number
	 * @return whether the number is elected
	 */
	private boolean isElectedNumber(int[] electedNumbers, int target) {
		int[] copy = new int[electedNumbers.length];
		for (int i = 0; i < copy.length; i++) {
			copy[i] = electedNumbers[i];
		};

		Arrays.sort(copy);
		int result = Arrays.binarySearch(copy, target);

		return result >= 0;
	}

	/*************************************
	 * Gettere & Setter for initializable parameter(s)
	 *************************************/

	/**
	 * Returns the initializable parameter r
	 * 
	 * @return r
	 */
	public int getR() {
		return r;
	}

	/**
	 * Set the initializable parameter r
	 * 
	 * @param r
	 */
	public void setR(int r) {
		this.r = r;
	}

	/**
	 * Returns the description for r
	 * 
	 * @return the description forr
	 */
	public String getRComment() {
		return "ߖT͈(G[WFg֌WԐl)";
	}

	/**
	 * Returns the initializable parameter l
	 * 
	 * @return l
	 */
	public double getL() {
		return l;
	}

	/**
	 * Set the initializable parameter l
	 * 
	 * @param l
	 */
	public void setL(double l) {
		this.l = l;
	}

	/**
	 * Returns the description for l
	 * 
	 * @return the description forl
	 */
	public String getLComment() {
		return "[JȃVFẢex";
	}

	/**
	 * Returns the initializable parameter g
	 * 
	 * @return g
	 */
	public double getG() {
		return g;
	}

	/**
	 * Set the initializable parameter g
	 * 
	 * @param g
	 */
	public void setG(double g) {
		this.g = g;
	}

	/**
	 * Returns the description for g
	 * 
	 * @return the description forg
	 */
	public String getGComment() {
		return "O[oȃVFẢex";
	}

	/**
	 * Returns the initializable parameter p
	 * 
	 * @return p
	 */
	public double getP() {
		return p;
	}

	/**
	 * Set the initializable parameter p
	 * 
	 * @param p
	 */
	public void setP(double p) {
		this.p = p;
	}

	/**
	 * Returns the description for p
	 * 
	 * @return the description forp
	 */
	public String getPComment() {
		return "ID̉ex";
	}

	/**
	 * Returns the initializable parameter consumerNumber
	 * 
	 * @return consumerNumber
	 */
	public int getConsumerNumber() {
		return consumerNumber;
	}

	/**
	 * Set the initializable parameter consumerNumber
	 * 
	 * @param consumerNumber
	 */
	public void setConsumerNumber(int consumerNumber) {
		this.consumerNumber = consumerNumber;
	}

	/**
	 * Returns the description for consumerNumber
	 * 
	 * @return the description forconsumerNumber
	 */
	public String getConsumerNumberComment() {
		return "҂̐l";
	}

	/**
	 * Returns the initializable parameter initialDurability
	 * 
	 * @return initialDurability
	 */
	public int getInitialDurability() {
		return initialDurability;
	}

	/**
	 * Set the initializable parameter initialDurability
	 * 
	 * @param initialDurability
	 */
	public void setInitialDurability(int initialDurability) {
		this.initialDurability = initialDurability;
	}

	/**
	 * Returns the description for initialDurability
	 * 
	 * @return the description forinitialDurability
	 */
	public String getInitialDurabilityComment() {
		return "VCȐϋvx";
	}

}
