/*
 * AbstractPurchaseVCRBehavior.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.model.behavior;

import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;

import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.GuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;

/**
* AbstractPurchaseVCRBehavior
*/
public abstract class AbstractPurchaseVCRBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from AbstractBehavior Builder
	* Don't touch by hand
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState sVFA˗ = factory.createCompositeState("sVFA˗");
		CompositeState sVFA҂ = factory.createCompositeState("sVFA҂");
		CompositeState Ki҂ = factory.createCompositeState("Ki҂");
		CompositeState vTR҂ = factory.createCompositeState("VTR҂");
		State terminalState = factory.createTerminalState();

		//actions
		Action mlɎgpKiq˂ = new Action() {
			public void doAction() {
				mlɎgpKiq˂();
			}
			public String toString() {
				return "mlɎgpKiq˂";
			}
		};
		Action sVFAL = new Action() {
			public void doAction() {
				sVFAL();
			}
			public String toString() {
				return "sVFAL";
			}
		};
		Action useBehaviorN = new Action() {
			public void doAction() {
				useBehaviorN();
			}
			public String toString() {
				return "useBehaviorN";
			}
		};
		Action sVFAq˂ = new Action() {
			public void doAction() {
				sVFAq˂();
			}
			public String toString() {
				return "sVFAq˂";
			}
		};
		Action wO]s = new Action() {
			public void doAction() {
				wO]s();
			}
			public String toString() {
				return "wO]s";
			}
		};
		Action KiL = new Action() {
			public void doAction() {
				KiL();
			}
			public String toString() {
				return "KiL";
			}
		};
		Action vCR𒍕 = new Action() {
			public void doAction() {
				vCR𒍕();
			}
			public String toString() {
				return "vCR𒍕";
			}
		};
		Action ӃVFAvZ = new Action() {
			public void doAction() {
				ӃVFAvZ();
			}
			public String toString() {
				return "ӃVFAvZ";
			}
		};

		//guard-conditions
		GuardCondition Ki = new GuardCondition() {
			public boolean isMatched(Event e) {
				return Ki(e);
			}
		};
		GuardCondition ׂĂ̕ԓ󂯎ꍇ = new GuardCondition() {
			public boolean isMatched(Event e) {
				return ׂĂ̕ԓ󂯎ꍇ(e);
			}
		};
		GuardCondition vTR = new GuardCondition() {
			public boolean isMatched(Event e) {
				return vTR(e);
			}
		};
		GuardCondition sVFA = new GuardCondition() {
			public boolean isMatched(Event e) {
				return sVFA(e);
			}
		};

		//transitions
		Transition transitionVTR҂ToTerminalState = factory.createTransition();
		Transition transitionsVFA҂ToKi҂ = factory.createTransition();
		Transition transitionsVFA˗TosVFA҂ = factory.createTransition();
		Transition transitionInitialStateTosVFA˗ = factory.createTransition();
		Transition transitionKi҂ToKi҂ = factory.createTransition();
		Transition transitionKi҂ToVTR҂ = factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		this.addState(sVFA˗);
		this.addState(sVFA҂);
		this.addState(Ki҂);
		this.addState(vTR҂);
		this.addTerminalState(terminalState);

		//transitions setting
		transitionVTR҂ToTerminalState.setEvent(ChannelEvent.class);
		transitionVTR҂ToTerminalState.setGuardCondition(vTR);
		transitionVTR҂ToTerminalState.addAction(useBehaviorN);
		transitionsVFA҂ToKi҂.setEvent(ChannelEvent.class);
		transitionsVFA҂ToKi҂.setGuardCondition(sVFA);
		transitionsVFA҂ToKi҂.addAction(sVFAL);
		transitionsVFA҂ToKi҂.addAction(mlɎgpKiq˂);
		transitionsVFA˗TosVFA҂.addAction(sVFAq˂);
		transitionKi҂ToKi҂.setEvent(ChannelEvent.class);
		transitionKi҂ToKi҂.setGuardCondition(Ki);
		transitionKi҂ToKi҂.addAction(KiL);
		transitionKi҂ToVTR҂.setGuardCondition(ׂĂ̕ԓ󂯎ꍇ);
		transitionKi҂ToVTR҂.addAction(ӃVFAvZ);
		transitionKi҂ToVTR҂.addAction(wO]s);
		transitionKi҂ToVTR҂.addAction(vCR𒍕);

		//connection of transitions
		transitionVTR҂ToTerminalState.setSourceState(vTR҂);
		transitionVTR҂ToTerminalState.setTargetState(terminalState);
		transitionsVFA҂ToKi҂.setSourceState(sVFA҂);
		transitionsVFA҂ToKi҂.setTargetState(Ki҂);
		transitionsVFA˗TosVFA҂.setSourceState(sVFA˗);
		transitionsVFA˗TosVFA҂.setTargetState(sVFA҂);
		transitionInitialStateTosVFA˗.setSourceState(initialState);
		transitionInitialStateTosVFA˗.setTargetState(sVFA˗);
		transitionKi҂ToKi҂.setSourceState(Ki҂);
		transitionKi҂ToKi҂.setTargetState(Ki҂);
		transitionKi҂ToVTR҂.setSourceState(Ki҂);
		transitionKi҂ToVTR҂.setTargetState(vTR҂);

	}

	/**
	*mlɎgpKiq˂
	*/
	protected abstract void mlɎgpKiq˂();
	/**
	*sVFAL
	*/
	protected abstract void sVFAL();
	/**
	*useBehaviorN
	*/
	protected abstract void useBehaviorN();
	/**
	*sVFAq˂
	*/
	protected abstract void sVFAq˂();
	/**
	*wO]s
	*/
	protected abstract void wO]s();
	/**
	*KiL
	*/
	protected abstract void KiL();
	/**
	*vCR𒍕
	*/
	protected abstract void vCR𒍕();
	/**
	*ӃVFAvZ
	*/
	protected abstract void ӃVFAvZ();
	/**
	*Ki
	*/
	protected abstract boolean Ki(Event e);
	/**
	*ׂĂ̕ԓ󂯎ꍇ
	*/
	protected abstract boolean ׂĂ̕ԓ󂯎ꍇ(Event e);
	/**
	*vTR
	*/
	protected abstract boolean vTR(Event e);
	/**
	*sVFA
	*/
	protected abstract boolean sVFA(Event e);
}
