/*
 * AbstractUseVCRBehavior.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.model.behavior;

import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;

import org.boxed_economy.besp.model.fmfw.TimeEvent;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.GuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;

/**
* AbstractUseVCRBehavior
*/
public abstract class AbstractUseVCRBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from AbstractBehavior Builder
	* Don't touch by hand
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState ԑ҂ = factory.createCompositeState("ԑ҂");
		State terminalState = factory.createTerminalState();

		//actions
		Action purchaseBehaviorN = new Action() {
			public void doAction() {
				purchaseBehaviorN();
			}
			public String toString() {
				return "purchaseBehaviorN";
			}
		};
		Action vCRgp = new Action() {
			public void doAction() {
				vCRgp();
			}
			public String toString() {
				return "vCRgp";
			}
		};
		Action ̏ႵVCR̂Ă = new Action() {
			public void doAction() {
				̏ႵVCR̂Ă();
			}
			public String toString() {
				return "̏ႵVCR̂Ă";
			}
		};

		//guard-conditions
		GuardCondition ̏ႵVCRĂꍇ = new GuardCondition() {
			public boolean isMatched(Event e) {
				return ̏ႵVCRĂꍇ(e);
			}
		};
		GuardCondition ̏ႵĂȂVCRĂꍇ = new GuardCondition() {
			public boolean isMatched(Event e) {
				return ̏ႵĂȂVCRĂꍇ(e);
			}
		};

		//transitions
		Transition transitionԑ҂ToTerminalState = factory.createTransition();
		Transition transitionԑ҂Toԑ҂ = factory.createTransition();
		Transition transitionInitialStateToԑ҂ = factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		this.addState(ԑ҂);
		this.addTerminalState(terminalState);

		//transitions setting
		transitionԑ҂ToTerminalState.setEvent(TimeEvent.class);
		transitionԑ҂ToTerminalState.setGuardCondition(̏ႵVCRĂꍇ);
		transitionԑ҂ToTerminalState.addAction(̏ႵVCR̂Ă);
		transitionԑ҂ToTerminalState.addAction(purchaseBehaviorN);
		transitionԑ҂Toԑ҂.setEvent(TimeEvent.class);
		transitionԑ҂Toԑ҂.setGuardCondition(̏ႵĂȂVCRĂꍇ);
		transitionԑ҂Toԑ҂.addAction(vCRgp);

		//connection of transitions
		transitionԑ҂ToTerminalState.setSourceState(ԑ҂);
		transitionԑ҂ToTerminalState.setTargetState(terminalState);
		transitionԑ҂Toԑ҂.setSourceState(ԑ҂);
		transitionԑ҂Toԑ҂.setTargetState(ԑ҂);
		transitionInitialStateToԑ҂.setSourceState(initialState);
		transitionInitialStateToԑ҂.setTargetState(ԑ҂);

	}

	/**
	*purchaseBehaviorN
	*/
	protected abstract void purchaseBehaviorN();
	/**
	*vCRgp
	*/
	protected abstract void vCRgp();
	/**
	*̏ႵVCR̂Ă
	*/
	protected abstract void ̏ႵVCR̂Ă();
	/**
	*̏ႵVCRĂꍇ
	*/
	protected abstract boolean ̏ႵVCRĂꍇ(Event e);
	/**
	*̏ႵĂȂVCRĂꍇ
	*/
	protected abstract boolean ̏ႵĂȂVCRĂꍇ(Event e);
}
