/*
 * PermitVCRNeedsBehavior.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.model.behavior;

import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.informations.YesNoInformation;
import org.boxed_economy.components.stepclock.StepClock;
import org.boxed_economy.formatcompetition.model.FormatCompetitionModel;
import org.boxed_economy.formatcompetition.model.FormatCompetitionWorld;
import org
	.boxed_economy
	.formatcompetition
	.model
	.function
	.DiffusionSigmoidFunction;

/**
 * @author macchan
 * @version $Id: PermitVCRNeedsBehavior.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public class PermitVCRNeedsBehavior extends AbstractPermitVCRNeedsBehavior {

	private double gt = 0d;
	private int permitAgentNum = 0;

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractPermitVCRNeedsBehavior#~ʂԓ()
	 */
	protected void ~ʂԓ() {
		int currentMax =
			(int) (this.gt
				* (double) this.getFormatCompetitionWorld().getConsumerNumber());
		boolean permition = false;
		if (this.permitAgentNum < currentMax) {
			permition = true;
			this.permitAgentNum++;
		}
		this.sendInformation(new YesNoInformation(permition));
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractPermitVCRNeedsBehavior#JE^[Zbg()
	 */
	protected void JE^[Zbg() {
		this.gt =
			new DiffusionSigmoidFunction(
				(StepClock) this.getWorld().getClock())
				.getCurrentValue();
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractPermitVCRNeedsBehavior#~˗(Event)
	 */
	protected boolean ~˗(Event e) {
		return this.getReceivedInformation()
			== FormatCompetitionModel
				.INFORMATIONTYPE_NeedsPermissionRequestInformation;
	}

	private FormatCompetitionWorld getFormatCompetitionWorld() {
		return (FormatCompetitionWorld) this.getWorld();
	}

}
