/*
 * PurchaseVCRBehavior.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.model.behavior;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.informations.DoubleInformation;
import org.boxed_economy.components.stepclock.StepClock;
import org.boxed_economy.formatcompetition.model.FormatCompetitionModel;
import org.boxed_economy.formatcompetition.model.FormatCompetitionWorld;
import org.boxed_economy.formatcompetition.model.function.LogitSelection;
import org.boxed_economy.formatcompetition.model.function.LogitSelectionModel;
import org.boxed_economy.formatcompetition.model.function.RentalSigmoidFunction;
import org
	.boxed_economy
	.formatcompetition
	.model
	.information
	.FormatAnswerInformation;
import org
	.boxed_economy
	.formatcompetition
	.model
	.information
	.FormatAnswerListInformation;
import org.boxed_economy.formatcompetition.model.information.OrderInformation;

/**
 * @author macchan
 * @version $Id: PurchaseVCRBehavior.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public class PurchaseVCRBehavior extends AbstractPurchaseVCRBehavior {

	private int receiveCounter = 0;
	private FormatAnswerListInformation friendsAnswers;

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {
		//		if (!this
		//			.getAgent()
		//			.hasInformation(FormatCompetitionModel.INFORMATION_P)) {
		//			double random =
		//				this.getWorld().getRandomNumberGenerator().generate();
		//			this.getAgent().putInformation(
		//				FormatCompetitionModel.INFORMATION_P,
		//				new DoubleInformation(random));
		//		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractPurchaseVCRBehavior#mlɎgpKiq˂()
	 */
	protected void mlɎgpKiq˂() {
		this.friendsAnswers = new FormatAnswerListInformation();
		this.receiveCounter =
			this.sendInformation(
				FormatCompetitionModel.RELATIONTYPE_FriendRelation,
				FormatCompetitionModel.BEHAVIORTYPE_ReplyFormatBehavior,
				FormatCompetitionModel
					.INFORMATIONTYPE_FormatQuestionInformation);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractPurchaseVCRBehavior#sVFAL()
	 */
	protected void sVFAL() {
		this.getAgent().putInformation(this.getReceivedInformation());
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractPurchaseVCRBehavior#useBehaviorN()
	 */
	protected void useBehaviorN() {
		//󂯎邪Ă̂łɏ
		this.getAgent().addGoods(this.getReceivedGoods());
		this.getActiveChannel().close();
		//UseBehaviorN
		this.getAgent().addBehavior(
			FormatCompetitionModel.BEHAVIORTYPE_UseVCRBehavior);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractPurchaseVCRBehavior#sVFAq˂()
	 */
	protected void sVFAq˂() {
		this.sendInformation(
			FormatCompetitionModel.RELATIONTYPE_InformationSupplierRelation,
			FormatCompetitionModel.BEHAVIORTYPE_SurveyBehavior,
			FormatCompetitionModel
				.INFORMATIONTYPE_FormatAnswerListRequestInformation);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractPurchaseVCRBehavior#wO]s()
	 */
	protected void wO]s() {
		//globalVFA
		FormatAnswerListInformation globalShare =
			(FormatAnswerListInformation) this.getAgent().getInformation(
				FormatAnswerListInformation.class);
		//localVFA
		FormatAnswerListInformation localShare = this.friendsAnswers;
		//eϐ
		double l = this.getFormatCompetitionWorld().getL();
		double g = this.getFormatCompetitionWorld().getG();
		double p = this.getFormatCompetitionWorld().getP();
		double P =
			((DoubleInformation) this
				.getAgent()
				.getInformation(
					FormatCompetitionModel
						.INFORMATIONTYPE_PreferenceInformation))
				.getValue();
		//^y
		double gt =
			new RentalSigmoidFunction(
				(StepClock) this.getWorld().getClock(),
				g)
				.getCurrentValue();

		//ŨXg
		List uList = new ArrayList();
		Iterator i =
			FormatCompetitionModel.GOODSTYPE_VCRGoods.getChildren().iterator();
		while (i.hasNext()) {
			GoodsType format = (GoodsType) i.next();
			double u =
				l * localShare.getShare(format)
					+ gt * globalShare.getShare(format)
					+ p * P;
			uList.add(new LogitSelectionModel(format, u));
		}
		//߂
		LogitSelection logit =
			new LogitSelection(
				this.getWorld().getRandomNumberGenerator(),
				uList);
		GoodsType decidedFormat = (GoodsType) logit.selection();

		//
		this.sendInformation(
			FormatCompetitionModel.RELATIONTYPE_SellerRelation,
			FormatCompetitionModel.BEHAVIORTYPE_SellVCRBehavior,
			new OrderInformation(this.getAgent(), decidedFormat),
			true);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractPurchaseVCRBehavior#KiL()
	 */
	protected void KiL() {
		this.friendsAnswers.addFormatAnswer(
			(FormatAnswerInformation) this.getReceivedInformation());
		this.receiveCounter--;
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractPurchaseVCRBehavior#vCR𒍕()
	 */
	protected void vCR𒍕() {
		//wO]ɔĂ܂
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractPurchaseVCRBehavior#ӃVFAvZ()
	 */
	protected void ӃVFAvZ() {
		//Ȃ(Ȃėǂ)
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractPurchaseVCRBehavior#Ki(Event)
	 */
	protected boolean Ki(Event e) {
		return this.getWorld().getInformationType(
			this.getReceivedInformation()).equals(
			FormatCompetitionModel.INFORMATIONTYPE_FormatAnswerInformation);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractPurchaseVCRBehavior#ׂĂ̕ԓ󂯎ꍇ(Event)
	 */
	protected boolean ׂĂ̕ԓ󂯎ꍇ(Event e) {
		return this.receiveCounter == 0;
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractPurchaseVCRBehavior#vTR(Event)
	 */
	protected boolean vTR(Event e) {
		return this.getReceivedGoods().getType().equals(
			FormatCompetitionModel.GOODSTYPE_VCRGoods);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractPurchaseVCRBehavior#sVFA(Event)
	 */
	protected boolean sVFA(Event e) {
		return this.getWorld().getInformationType(
			this.getReceivedInformation()).equals(
			FormatCompetitionModel.INFORMATIONTYPE_FormatAnswerListInformation);
	}

	private FormatCompetitionWorld getFormatCompetitionWorld() {
		return (FormatCompetitionWorld) this.getWorld();
	}

}
