/*
 * RecognizeVCRNeedsBehavior.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.model.behavior;

import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.informations.YesNoInformation;
import org.boxed_economy.formatcompetition.model.FormatCompetitionModel;

/**
 * @author macchan
 * @version $Id: RecognizeVCRNeedsBehavior.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public class RecognizeVCRNeedsBehavior
	extends AbstractRecognizeVCRNeedsBehavior {

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractRecognizeVCRNeedsBehavior#~˗()
	 */
	protected void ~˗() {
		this.sendInformation(
			FormatCompetitionModel.RELATIONTYPE_DiffusionControllerRelation,
			FormatCompetitionModel.BEHAVIORTYPE_PermitVCRNeedsBehavior,
			FormatCompetitionModel
				.INFORMATIONTYPE_NeedsPermissionRequestInformation);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractRecognizeVCRNeedsBehavior#purchaseBehaviorN()
	 */
	protected void purchaseBehaviorN() {
		this.getAgent().addBehavior(
			FormatCompetitionModel.BEHAVIORTYPE_PurchaseVCRBehavior);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractRecognizeVCRNeedsBehavior#~ʂ󂯎()
	 */
	protected void ~ʂ󂯎() {
		this.getAgent().putInformation(
			FormatCompetitionModel.INFORMATIONTYPE_NeedsPermissionInformation,
			this.getReceivedInformation());
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractRecognizeVCRNeedsBehavior#~Ȃꍇ(Event)
	 */
	protected boolean ~Ȃꍇ(Event e) {
		return !this.~ꂽꍇ(e);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractRecognizeVCRNeedsBehavior#vCRĂȂꍇ(Event)
	 */
	protected boolean vCRĂȂꍇ(Event e) {
		return !this.getAgent().hasGoods(
			FormatCompetitionModel.GOODSTYPE_VCRGoods);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractRecognizeVCRNeedsBehavior#~ꂽꍇ(Event)
	 */
	protected boolean ~ꂽꍇ(Event e) {
		return (
			(YesNoInformation) this.getAgent().getInformation(
				FormatCompetitionModel
					.INFORMATIONTYPE_NeedsPermissionInformation))
			.isYes();
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractRecognizeVCRNeedsBehavior#~(Event)
	 */
	protected boolean ~(Event e) {
		return this.getWorld().getInformationType(
			this.getReceivedInformation())
			== this.getWorld().getInformationType(
				YesNoInformation.class.getName());
	}

}
