/*
 * SellVCRBehavior.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.model.behavior;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.boxed_economy.besp.model.fmfw.Channel;
import org.boxed_economy.besp.model.fmfw.Goods;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.formatcompetition.model.FormatCompetitionModel;
import org.boxed_economy.formatcompetition.model.information.OrderInformation;

/**
 * @author macchan
 * @version $Id: SellVCRBehavior.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public class SellVCRBehavior extends AbstractSellVCRBehavior {

	private Map orders = new HashMap();

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractSellVCRBehavior#L^()
	 */
	protected void L^() {
		this.orders.put(this.getActiveChannel(), this.getReceivedInformation());
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractSellVCRBehavior#ׂĂ̒ɂVCR𒲒BĔ̔()
	 */
	protected void ׂĂ̒ɂVCR𒲒BĔ̔() {
		Iterator i = this.orders.keySet().iterator();
		while (i.hasNext()) {
			Channel channel = (Channel) i.next();
			OrderInformation order =
				(OrderInformation) this.orders.get(channel);
			Goods vcr = this.getWorld().createGoods(order.getFormat(), 1.0);
			channel.sendGoods(vcr, this);
		}

		this.orders = new HashMap();
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractSellVCRBehavior#(Event)
	 */
	protected boolean (Event e) {
		return this.getWorld().getInformationType(
			this.getReceivedInformation())
			== FormatCompetitionModel.INFORMATIONTYPE_OrderInformation;
	}

}
