/*
 * UseVCRBehavior.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.model.behavior;

import org.boxed_economy.besp.model.fmfw.Goods;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.informations.IntegerInformation;
import org.boxed_economy.formatcompetition.model.FormatCompetitionModel;
import org.boxed_economy.formatcompetition.model.FormatCompetitionWorld;

/**
 * @author macchan
 * @version $Id: UseVCRBehavior.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public class UseVCRBehavior extends AbstractUseVCRBehavior {

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {
		this.getVCR().putInformation(
			FormatCompetitionModel.INFORMATIONTYPE_DurabilityInformation,
			new IntegerInformation(this.getInitialDurability()));
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractUseVCRBehavior#̏ႵVCR̂Ă()
	 */
	protected void ̏ႵVCR̂Ă() {
		this.getAgent().removeAllGoodsRecursively(
			FormatCompetitionModel.GOODSTYPE_VCRGoods);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractUseVCRBehavior#vCRgp()
	 */
	protected void vCRgp() {
		IntegerInformation durability =
			(IntegerInformation) this.getVCR().getInformation(
				FormatCompetitionModel.INFORMATIONTYPE_DurabilityInformation);
		durability.setValue(durability.getValue() - 1);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractUseVCRBehavior#purchaseBehaviorN()
	 */
	protected void purchaseBehaviorN() {
		this.getAgent().addBehavior(
			FormatCompetitionModel.BEHAVIORTYPE_PurchaseVCRBehavior);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractUseVCRBehavior#̏ႵVCRĂꍇ(Event)
	 */
	protected boolean ̏ႵVCRĂꍇ(Event e) {
		return !̏ႵĂȂVCRĂꍇ(e);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.behavior.AbstractUseVCRBehavior#̏ႵĂȂVCRĂꍇ(Event)
	 */
	protected boolean ̏ႵĂȂVCRĂꍇ(Event e) {
		IntegerInformation durability =
			(IntegerInformation) this.getVCR().getInformation(
				FormatCompetitionModel.INFORMATIONTYPE_DurabilityInformation);
		return durability.getValue() > 0;
	}

	private Goods getVCR() {
		Goods goods =
			(Goods) this
				.getAgent()
				.removeAllGoodsRecursively(
					FormatCompetitionModel.GOODSTYPE_VCRGoods)
				.iterator()
				.next();
		this.getAgent().addGoods(goods);
		return goods;
	}

	private int getInitialDurability() {
		return ((FormatCompetitionWorld) this.getWorld())
			.getInitialDurability();
	}

}
