/*
 * DiffusionSigmoidFunction.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.model.function;

import org.boxed_economy.components.stepclock.StepClock;

/**
 * @author macchan
 * @version $Id: DiffusionSigmoidFunction.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public class DiffusionSigmoidFunction extends SigmoidFunction {

	/**
	 * Constructor for DiffusionSigmoidFunction.
	 * @param stepClock
	 * @param g
	 */
	public DiffusionSigmoidFunction(StepClock stepClock) {
		super(stepClock, 1d);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.information.SigmoidFunction#getDenominator()
	 */
	protected double getDenominator() {
		return 1d + Math.exp((- (this.getStep() - 10d)) / 2d);
	}

	/**
	 * ؁AA܂
	 */
	public static void main(String args[]) {
		StepClock clock = new StepClock();
		SigmoidFunction func = new DiffusionSigmoidFunction(clock);
		for (int i = 0; i < 40; i++) {
			System.out.println(func.getCurrentValue());
			clock.gain();
		}
	}

}
