/*
 * LogitSelection.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.model.function;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.DefaultRandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.Type;

/**
 * @author macchan
 * @version $Id: LogitSelection.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public class LogitSelection {

	private List candidates = null;
	private RandomNumberGenerator random = null;

	/**
	 * Constructor for LogitSelection.
	 */
	public LogitSelection(RandomNumberGenerator random, List candidates) {
		this.random = random;
		this.candidates = candidates;
	}

	/**
	 * I܂
	 */
	public Type selection() {

		//Expv߂	
		double total = this.getTotal();

		//TCRU(0`1̏)
		double generatedRate = this.random.generate();

		//I͈͓TypeT
		double currentTotal = 0.0;
		Iterator i = this.candidates.iterator();
		while (i.hasNext()) {
			LogitSelectionModel model = (LogitSelectionModel) i.next();
			currentTotal = currentTotal + Math.exp(model.getU());
			double currentTotalRate = currentTotal / total;
			if (generatedRate < currentTotalRate) {
				return model.getCandidate();
			}
		}

		throw new ModelException("illegal logitmodel argolism");
	}

	private double getTotal() {
		double total = 0.0;
		Iterator i = this.candidates.iterator();
		while (i.hasNext()) {
			LogitSelectionModel model = (LogitSelectionModel) i.next();
			total = total + Math.exp(model.getU());
		}
		return total;
	}

	/**
	 * ؂łȂAA܂̂Ăł
	 */
	public static void main(String args[]) throws Exception {
		RandomNumberGenerator random =
			new DefaultRandomNumberGenerator("test", System.currentTimeMillis());

		ModelContainer container = new ModelContainer(null);
		GoodsType VHS = container.installGoodsType("VHS");
		GoodsType Beta = container.installGoodsType("Beta");
		GoodsType Hi8 = container.installGoodsType("Hi8");

		List candidates = new ArrayList();
		candidates.add(new LogitSelectionModel(VHS, 33));
		candidates.add(new LogitSelectionModel(Beta, 34));
		candidates.add(new LogitSelectionModel(Hi8, 34));
		LogitSelection logit = new LogitSelection(random, candidates);

		for (int i = 0; i < 30; i++) {
			System.out.println(logit.selection());
		}
	}

}
