/*
 * RentalSigmoidFunction.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.model.function;

import org.boxed_economy.components.stepclock.StepClock;

/**
 * @author macchan
 * @version $Id: RentalSigmoidFunction.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public class RentalSigmoidFunction extends SigmoidFunction {

	/**
	 * Constructor for RentalSigmoidFunction.
	 * @param stepClock
	 * @param g
	 */
	public RentalSigmoidFunction(StepClock stepClock, double g) {
		super(stepClock, g);
	}

	/**
	 * @see org.boxed_economy.formatcompetition.model.information.SigmoidFunction#getDenominator()
	 */
	protected double getDenominator() {
		return 1d + Math.exp(- (this.getStep() - 7d));
	}

	/**
	 * ؁AA܂
	 */
	public static void main(String args[]) {
		double g = 10d;
		StepClock clock = new StepClock();
		SigmoidFunction func = new RentalSigmoidFunction(clock, g);
		for (int i = 0; i < 40; i++) {
			System.out.println(func.getCurrentValue());
			clock.gain();
		}
	}

}
