/*
 * SigmoidFunction.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.model.function;

import org.boxed_economy.components.stepclock.StepClock;

/**
 * @author macchan
 * @version $Id: SigmoidFunction.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public abstract class SigmoidFunction {

	private StepClock stepClock = null;
	private double g = 0d;

	/**
	 * Constructor for SigmoidFunction.
	 */
	public SigmoidFunction(StepClock stepClock, double g) {
		this.stepClock = stepClock;
		this.g = g;
	}

	/**
	 * Returns the g.
	 * @return double
	 */
	public double getStep() {
		return (double)this.stepClock.getStep() / 2d;
	}
	
	/**
	 * ݂̒lԂ܂
	 */
	public double getCurrentValue() {
		return g / this.getDenominator();
	}
	
	protected abstract double getDenominator();

}
