/*
 * FormatAnswerListInformation.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.model.information;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.Information;

/**
 * @author macchan
 * @version $Id: FormatAnswerListInformation.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public class FormatAnswerListInformation implements Information {

	private Map answers = new HashMap();
	private int hasFormatAnswerTotal = 0;
	private int answerTotal = 0;

	/**
	 * Constructor for FormatAnswerListInformation.
	 */
	public FormatAnswerListInformation() {
		super();
	}

	/**
	 * FormatAnswerǉ܂
	 */
	public void addFormatAnswer(FormatAnswerInformation answer) {
		if (answer.hasFormat()) {
			GoodsType format = answer.getFormat();
			if (!this.answers.containsKey(format)) {
				this.answers.put(format, new ArrayList());
			}
			((List) this.answers.get(format)).add(answer);
			this.hasFormatAnswerTotal++;
		}
		this.answerTotal++;
	}

	/**
	 * ΏۂƂȂFormatԂ܂
	 */
	public Set getFormats() {
		return this.answers.keySet();
	}

	/**
	 * ΏGoodsTypẽVFAvZĕԂ܂B
	 */
	public double getShare(GoodsType format) {
		if (!this.answers.containsKey(format)) {
			return 0d;
		}
		int answerCount = this.getFormatAnswerCount(format);
		return (double) answerCount / (double) this.hasFormatAnswerTotal;
	}

	/**
	 * yԂ܂
	 */
	public double getDiffusionRate() {
		return (double) this.hasFormatAnswerTotal / (double) answerTotal;
	}

	private int getFormatAnswerCount(GoodsType format) {
		return ((List) this.answers.get(format)).size();
	}

	public void dump() {
		System.out.println("y=" + this.getDiffusionRate() * 100);
		System.out.println("tH[}bg\tVFA");
		Iterator i = this.getFormats().iterator();
		while (i.hasNext()) {
			GoodsType format = (GoodsType) i.next();
			System.out.println(format + "\t" + this.getShare(format) * 100);
		}
	}

	public static void main(String args[]) {
		ModelContainer container = new ModelContainer(null);
		GoodsType VHS = container.installGoodsType("VHS");
		GoodsType Beta = container.installGoodsType("Beta");
		GoodsType Hi8 = container.installGoodsType("Hi8");

		FormatAnswerListInformation formatList = new FormatAnswerListInformation();
		formatList.addFormatAnswer(new FormatAnswerInformation(null));
		formatList.addFormatAnswer(new FormatAnswerInformation(null));
		formatList.addFormatAnswer(new FormatAnswerInformation(null));
		formatList.addFormatAnswer(new FormatAnswerInformation(null));
		formatList.addFormatAnswer(new FormatAnswerInformation(null));
		formatList.addFormatAnswer(new FormatAnswerInformation(null, VHS));
		formatList.addFormatAnswer(new FormatAnswerInformation(null, VHS));
		formatList.addFormatAnswer(new FormatAnswerInformation(null, VHS));
		formatList.addFormatAnswer(new FormatAnswerInformation(null, Beta));
		formatList.addFormatAnswer(new FormatAnswerInformation(null, Hi8));

		formatList.dump();
	}

}
