/*
 * FormatCompetitionScope.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.model.information;

import java.util.ArrayList;
import java.util.List;

import org.boxed_economy.components.cell.Cell;
import org.boxed_economy.components.cell.CellScope;

/**
 * @author macchan
 * @version $Id: FormatCompetitionScope.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public class FormatCompetitionScope implements CellScope {

	private int range = 0;
	private List cellList = new ArrayList();

	/**
	 * Constructor for FormatCompetitionScope.
	 */
	public FormatCompetitionScope(int range) {
		this.range = range;
		for (int i = 1; i < range + 1; i++) {
			cellList.add(new Cell(0, i));
		}
	}

	/**
	 * @see org.boxed_economy.components.cell.CellScope#getRelativeCells()
	 */
	public List getRelativeCells() {
		return new ArrayList(cellList);
	}

}
