/*
 * FormatInformation.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.model.information;

import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.Information;

/**
 * @author macchan
 * @version $Id: FormatInformation.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public class FormatInformation implements Information{

	private Agent agent = null;
	private GoodsType format = null;

	/**
	 * Constructor for FormatInformation.
	 */
	public FormatInformation(Agent agent) {
		this(agent, null);
	}

	/**
	 * Constructor for FormatAnswerInformation.
	 */
	public FormatInformation(Agent agent, GoodsType format) {
		this.agent = agent;
		this.format = format;
	}

	/**
	 * Returns the agent.
	 * @return Agent
	 */
	public Agent getAgent() {
		return agent;
	}

	/**
	 * Returns the format.
	 * @return GoodsType
	 */
	public GoodsType getFormat() {
		return format;
	}

	/**
	 * ΏFormat̍Ă邩ǂ
	 */
	public boolean hasFormat() {
		return this.format != null;
	}


}
