/*
 * FormatCompetitionPresentationPlugin.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.presentation;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.presentation.bface.menu.Action;
import org.boxed_economy.besp.presentation.bface.menu.Menu;
import org.boxed_economy.besp.presentation.guifw.CreateComponentAction;
import org.boxed_economy.formatcompetition.model.FormatCompetitionModel;

/**
 * @author macchan
 * @version $Id: FormatCompetitionPresentationPlugin.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public class FormatCompetitionPresentationPlugin implements BESPPlugin {

	public static void initializePlugin(BESPContainer container) {

		Menu group = new Menu("FormatCompetition Viewer");
		container.getPresentationContainer().addMenuElementToShowMenu(group);

		Action openDiffusionVisualizerAction =
			new CreateComponentAction(
				"Diffusion Visualizer",
				VCRDiffusionVisualizer.class);
		group.add(openDiffusionVisualizerAction);
	}

	/**
	* ̃vOC̈ˑ֌WLq܂B
	* RealClockDataCollectorContainervOCɈˑĂ܂
	*/
	public static Class[] getDependentClasses() {
		return new Class[] { FormatCompetitionModel.class };
	}

}
