package org.boxed_economy.formatcompetition.presentation;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Collection;
import java.util.Iterator;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockListener;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.formatcompetition.model.FormatCompetitionModel;

/**
 * @author iba
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class VCRDiffusionVisualizer
	extends AbstractInternalFrameComponent
	implements UpdateClockListener {

	private JTextArea textArea = new JTextArea();
	private JPanel panel;
	private Container contentPane;
	private JScrollPane scroll;

	/**
	 * Constructor for VCRDiffusionVisualizer.
	 */
	public VCRDiffusionVisualizer() {
		super();
	}

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#initialize()
	 */
	public void initialize() {
		this.setSize(new Dimension(620, 500));
		this.setTitle("Diffusion Visualizer");
		this.addUpdateClockListener(this);

		JScrollPane scroll = new JScrollPane();
		scroll.getViewport().add(this.textArea);
		this.getContentPane().add(scroll, BorderLayout.CENTER);

		Font fnt = new Font("Monospaced", Font.PLAIN, 6);
		this.textArea.setFont(fnt);

	}

	public void clockGained(UpdateClockEvent e) {

		String message = "|";
		String text = this.textArea.getText();

		World world = getWorld();
		if (world == null) {

		} else {

			Collection agents =
				world.getAgents(FormatCompetitionModel.AGENTTYPE_ConsumerAgent);

			Iterator i = agents.iterator();
			while (i.hasNext()) {
				Agent ag = (Agent) i.next();
				if (ag.hasGoods(FormatCompetitionModel.GOODSTYPE_Format1Goods))
					text += "";
				else if (ag.hasGoods(FormatCompetitionModel.GOODSTYPE_Format2Goods))
					text += "";
				else
					text += "@";
			}

			this.textArea.setText(text + message + "\n");
		}
	}

	private void clear() {
		this.textArea.setText("");
	}

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#terminate()
	 */
	public void terminate() {
		this.removeUpdateClockListener(this);
	}

}
