/*
 * BehaviorStateFrame.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.presentation.legacy;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateAgentEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;

/**
 * @author macchan
 * @version $Id: BehaviorStateFrame.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public class BehaviorStateFrame
	extends AbstractInternalFrameComponent
	implements UpdateAgentListener, ModelContainerListener {

	private JTextArea textArea = new JTextArea();

	/**
	 * Constructor for BehaviorStateFrame.
	 */
	public BehaviorStateFrame() {
		super();
	}

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#initialize()
	 */
	public void initialize() {
		this.setTitle("Behavior Monitor");
		this.getContentPane().setLayout(new BorderLayout());

		JScrollPane scroll = new JScrollPane();
		scroll.getViewport().add(this.textArea);
		this.getContentPane().add(scroll, BorderLayout.CENTER);

		JButton button = new JButton("Clear");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				clear();
			}
		});
		this.getContentPane().add(button, BorderLayout.SOUTH);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#terminate()
	 */
	public void terminate() {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#goodsAdded(UpdateAgentEvent)
	 */
	public void goodsAdded(UpdateAgentEvent e) {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#goodsRemoved(UpdateAgentEvent)
	 */
	public void goodsRemoved(UpdateAgentEvent e) {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#informationAdded(UpdateAgentEvent)
	 */
	public void informationAdded(UpdateAgentEvent e) {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#informationRemoved(UpdateAgentEvent)
	 */
	public void informationRemoved(UpdateAgentEvent e) {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#relationAdded(UpdateAgentEvent)
	 */
	public void relationAdded(UpdateAgentEvent e) {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#relationRemoved(UpdateAgentEvent)
	 */
	public void relationRemoved(UpdateAgentEvent e) {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#behaviorAdded(UpdateAgentEvent)
	 */
	public void behaviorAdded(UpdateAgentEvent e) {
		String message =
			"behavior added " + e.getObject() + " to " + e.getSource();
		String text = this.textArea.getText();
		this.textArea.setText(text + message + "\n");
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#behaviorRemoved(UpdateAgentEvent)
	 */
	public void behaviorRemoved(UpdateAgentEvent e) {
		String message =
			"behavior removed " + e.getObject() + " from " + e.getSource();
		String text = this.textArea.getText();
		this.textArea.setText(text + message + "\n");
	}

	private void clear() {
		this.textArea.setText("");
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldClose(ModelContainerEvent)
	 */
	public void prepareWorldClose(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldOpen(ModelContainerEvent)
	 */
	public void prepareWorldOpen(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldClosed(ModelContainerEvent)
	 */
	public void worldClosed(ModelContainerEvent ev) {
		this.removeUpdateAgentListener(this);
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldOpened(ModelContainerEvent)
	 */
	public void worldOpened(ModelContainerEvent ev) {
		this.addUpdateAgentListener(this);
	}

}
