/*
 * BehaviorStateFrame.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.formatcompetition.presentation.legacy;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateAgentEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockListener;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;

/**
 * @author macchan
 * @version $Id: StatusViewer.java,v 1.1 2004/06/10 08:10:22 bam Exp $
 */
public class StatusViewer
	extends AbstractInternalFrameComponent
	implements UpdateAgentListener, UpdateClockListener, ModelContainerListener {

	private JTextArea textArea = new JTextArea();
	private JPanel settingPanel = new JPanel(new GridLayout(1, 5));

	private JCheckBox checkInfo = new JCheckBox("Information");
	private JCheckBox checkGoods = new JCheckBox("Goods");
	private JCheckBox checkRelation = new JCheckBox("Relation");
	private JCheckBox checkBehavior = new JCheckBox("Behavior");
	private JCheckBox checkAgent = new JCheckBox("Agent");
	//private JCheckBox checkChannel = new JCheckBox("Channel");
	private JCheckBox checkClock = new JCheckBox("Clock", true);

	//NX\ۂɁApbP[Wȗ邩ǂ
	private JCheckBox checkAbridged = new JCheckBox("abbreviation", true);

	//ڕʂ̏o͂邩ǂ̃tO
	private boolean isPrintInfo = false;
	private boolean isPrintBehavior = false;
	private boolean isPrintGoods = false;
	private boolean isPrintRelation = false;
	private boolean isPrintAgent = false;
	//private boolean isPrintChannel = false;
	private boolean isPrintClock = true;

	private boolean isAbridged = true; //IuWFNgȗ\L邩

	/**
	 * Constructor for StatusViewer.
	 */
	public StatusViewer() {
		super();
	}

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#initialize()
	 */
	public void initialize() {
		this.setTitle("Status Viewer");
		this.setSize(new Dimension(600, 300));
		this.getContentPane().setLayout(new BorderLayout());

		JScrollPane scroll = new JScrollPane();
		scroll.getViewport().add(this.textArea);
		this.getContentPane().add(scroll, BorderLayout.CENTER);

		JButton button = new JButton("Clear");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				clear();
			}
		});
		this.getContentPane().add(button, BorderLayout.SOUTH);

		//̏o͂邩̐ݒ`FbN{bNX

		settingPanel.add(checkInfo);
		checkInfo.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				isPrintInfo = checkInfo.isSelected(); //`FbN{bNX̏Ԃ𔽉f
			}
		});

		settingPanel.add(checkGoods);
		checkGoods.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				isPrintGoods = checkGoods.isSelected(); //`FbN{bNX̏Ԃ𔽉f
			}
		});

		settingPanel.add(checkRelation);
		checkRelation.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				isPrintRelation = checkRelation.isSelected(); //`FbN{bNX̏Ԃ𔽉f
			}
		});

		settingPanel.add(checkBehavior);
		checkBehavior.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				isPrintBehavior = checkBehavior.isSelected(); //`FbN{bNX̏Ԃ𔽉f
			}
		});

		settingPanel.add(checkAgent);
		checkAgent.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				isPrintAgent = checkAgent.isSelected(); //`FbN{bNX̏Ԃ𔽉f
			}
		});

		//		settingPanel.add(checkChannel);
		//		checkChannel.addActionListener(new ActionListener() {
		//			public void actionPerformed(ActionEvent e) {
		//				isPrintChannel = checkChannel.isSelected(); //`FbN{bNX̏Ԃ𔽉f
		//			}
		//		});

		settingPanel.add(checkClock);
		checkClock.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				isPrintClock = checkClock.isSelected(); //`FbN{bNX̏Ԃ𔽉f
			}
		});

		settingPanel.add(checkAbridged);
		checkAbridged.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				isAbridged = checkAbridged.isSelected(); //`FbN{bNX̏Ԃ𔽉f
			}
		});

		this.getContentPane().add(settingPanel, BorderLayout.NORTH);

	}

	/* eLXgtB[h̎XN[itH[JXŌ̂ƂɎĂjEEEEłAd̂ł͂ĂƂɂ*/
	//	private void goEndPosition(){
	//		Document doc = textArea.getDocument();
	//		Position endPos = doc.getEndPosition();
	//		int pos = endPos.getOffset();
	//		textArea.getCaret().setDot(pos);
	//		textArea.requestFocus();
	//	}

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#terminate()
	 */
	public void terminate() {
	}

	//ef[^𐮌`ďo͂镔
	public void printStatus(
		String kind,
		String action,
		String object,
		String preposition,
		String source) {
		if (isAbridged) {

			if (kind != "Goods") {
				object = object.substring(object.lastIndexOf('.') + 1);
			}

			source = source.substring(source.lastIndexOf('.') + 1);

			//source = abridgedSource;
		}

		String message = kind + " " + action + object + preposition + source;
		String text = this.textArea.getText();
		this.textArea.setText(text + message + "\n");
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#goodsAdded(UpdateAgentEvent)
	 */
	public void goodsAdded(UpdateAgentEvent e) {
		if (isPrintGoods) {
			printStatus(
				"Goods",
				"Added   ",
				e.getObject().toString(),
				"  to  ",
				e.getSource().toString());
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#goodsRemoved(UpdateAgentEvent)
	 */
	public void goodsRemoved(UpdateAgentEvent e) {
		if (isPrintGoods) {
			printStatus(
				"Goods",
				"Removed ",
				e.getObject().toString(),
				"  from  ",
				e.getSource().toString());
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#informationAdded(UpdateAgentEvent)
	 */
	public void informationAdded(UpdateAgentEvent e) {
		if (isPrintInfo) {
			printStatus(
				"Infomation",
				"Added   ",
				e.getObject().toString(),
				"  to  ",
				e.getSource().toString());
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#informationRemoved(UpdateAgentEvent)
	 */
	public void informationRemoved(UpdateAgentEvent e) {
		if (isPrintInfo) {
			printStatus(
				"Information",
				"Removed ",
				e.getObject().toString(),
				"  From  ",
				e.getSource().toString());
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#relationAdded(UpdateAgentEvent)
	 */
	public void relationAdded(UpdateAgentEvent e) {
		if (isPrintRelation) {
			printStatus(
				"Relation",
				"Added ",
				e.getObject().toString(),
				"  to  ",
				e.getSource().toString());
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#relationRemoved(UpdateAgentEvent)
	 */
	public void relationRemoved(UpdateAgentEvent e) {
		if (isPrintRelation) {
			printStatus(
				"Relation",
				"Removed ",
				e.getObject().toString(),
				"  from  ",
				e.getSource().toString());
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#behaviorAdded(UpdateAgentEvent)
	 */
	public void behaviorAdded(UpdateAgentEvent e) {
		if (isPrintBehavior) {
			printStatus(
				"Behavior",
				"Added ",
				e.getObject().toString(),
				"  to  ",
				e.getSource().toString());
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#behaviorRemoved(UpdateAgentEvent)
	 */
	public void behaviorRemoved(UpdateAgentEvent e) {
		if (isPrintBehavior) {
			printStatus(
				"Behavior",
				"Removed ",
				e.getObject().toString(),
				"  from  ",
				e.getSource().toString());
		}
	}

	private void clear() {
		this.textArea.setText("");
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldClose(ModelContainerEvent)
	 */
	public void prepareWorldClose(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldOpen(ModelContainerEvent)
	 */
	public void prepareWorldOpen(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldClosed(ModelContainerEvent)
	 */
	public void worldClosed(ModelContainerEvent ev) {
		this.removeUpdateAgentListener(this);
		this.removeUpdateClockListener(this);
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldOpened(ModelContainerEvent)
	 */
	public void worldOpened(ModelContainerEvent ev) {
		this.addUpdateAgentListener(this);
		this.addUpdateClockListener(this);
	}

	//v\
	public void clockGained(UpdateClockEvent ev) {
		if (isPrintClock) {
			String message =
				"-------------------------------------"
					+ (ev.getSource()).toString();
			String text = this.textArea.getText();
			this.textArea.setText(text + message + "\n");
		}
	}

}
