/*
 * CollectionUtil.java
 * Created on 2003/10/10
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.collection;

import java.util.Arrays;
import java.util.List;

/**
 * Class CollectionUtil.
 * 
 * @author macchan
 * @version $Id: CollectionUtil.java,v 1.1 2003/12/11 10:26:52 macchan Exp $
 */
public class CollectionUtil {

	/**
	 * Constructor for CollectionUtil.
	 */
	private CollectionUtil() {
	}

	/**
	 * Print List.
	 * @param list
	 * @return
	 */
	public static void printList(List list) {
		System.out.println(listToString(list));
	}

	/**
	 * Print List.
	 * @param list
	 * @return
	 */
	public static void printList(List list, String name) {
		System.out.println(listToString(list, name));
	}

	/**
	 * List to String.
	 * @param list
	 * @return
	 */
	public static String listToString(List list) {
		return listToString(list, "List");
	}

	/**
	 * List to String.
	 * @param list
	 * @return
	 */
	public static String listToString(List list, String name) {
		StringBuffer buffer = new StringBuffer();

		buffer.append("========== " + name + " ==========\n");
		if (list.isEmpty()) {
			buffer.append("EMPTY\n");
		} else {
			for (int i = 0; i < list.size(); i++) {
				Object object = list.get(i);
				buffer.append("[" + i + "]" + " " + object + "\n");
			}
		}
		buffer.append("-------- " + name + " End --------");

		return buffer.toString();
	}

	/**
	 * Print Array
	 * @param list
	 * @return
	 */
	public static void printArray(Object[] array) {
		System.out.println(arrayToString(array));
	}

	/**
	 * Print Array
	 * @param list
	 * @return
	 */
	public static void printArray(Object[] array, String title) {
		System.out.println(arrayToString(array, title));
	}

	/**
	 * Array to String.
	 * @param list
	 * @return
	 */
	public static String arrayToString(Object[] array) {
		return listToString(Arrays.asList(array));
	}

	/**
	 * Array to String.
	 * @param list
	 * @return
	 */
	public static String arrayToString(Object[] array, String title) {
		return listToString(Arrays.asList(array), title);
	}
}
