/*
 * ListCoordinator.java
 * Created on 2003/10/10
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/**
 * Class ListCoordinator.
 * 
 * @author macchan
 * @version $Id: ListCoordinator.java,v 1.1 2003/12/11 10:26:52 macchan Exp $
 */
public class ListCoordinator {

	private ValueChangeListener listener;
	private List list = new ArrayList();

	/**
	 * Constructor for ListCoordinator.
	 */
	public ListCoordinator(ValueChangeListener listener) {
		this.listener = listener;
	}

	public void setList(List newList) {
		//Argument checks.
		if (newList == null) {
			newList = Collections.EMPTY_LIST;
		}

		//Checks reorderd or added list.
		int size = newList.size();
		for (int i = 0; i < size; i++) {
			Object newValue = newList.get(i);

			if (i < list.size() && list.get(i) == newValue) {
				//do nothing
			} else if (list.contains(newValue)) {
				listener.valueReorderd(newValue, i);
			} else {
				listener.valueAdded(newValue, i);
			}
		}

		//Checks removed list.
		list.removeAll(newList);
		for (Iterator i = list.iterator(); i.hasNext();) {
			Object removedValue = i.next();
			listener.valueRemoved(removedValue);
		}

		//Refresh list.
		this.list = new ArrayList(newList);
	}

	/**
	 * Gets the list.
	 * @return
	 */
	public List getList() {
		return new ArrayList(list);
	}

}
